/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.item;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.EnumUtil;
import net.bitbylogic.packetblocks.lib.bitsutils.NumberUtil;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.config.ConfigSerializer;
import net.bitbylogic.packetblocks.lib.bitsutils.item.PaperConsumableProvider;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.Formatter;
import net.bitbylogic.packetblocks.lib.bitsutils.server.ServerUtil;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.consumable.ConsumableComponent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class ItemStackConfigSerializer
implements ConfigSerializer<ItemStack> {
    @Override
    public Optional<ItemStack> serializeFrom(@NonNull ConfigurationSection section) {
        ConfigurationSection toolSection;
        ConfigurationSection foodSection;
        ConfigurationSection equippableSection;
        SkullMeta skullMeta;
        ConfigurationSection potionSection;
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        int amount = section.getInt("Amount", 1);
        ItemStack stack = new ItemStack(Material.valueOf((String)Formatter.format(section.getString("Material", "BARRIER"), new StringModifier[0])), amount);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return Optional.of(stack);
        }
        if (section.getString("Name") != null) {
            meta.setDisplayName(Formatter.format(section.getString("Name"), new StringModifier[0]));
        }
        ArrayList lore = Lists.newArrayList();
        section.getStringList("Lore").forEach(string -> lore.add(Formatter.format(string, new StringModifier[0])));
        meta.setLore((List)lore);
        meta.setMaxStackSize(Integer.valueOf(section.getInt("Max-Stack-Size", meta.hasMaxStackSize() ? meta.getMaxStackSize() : 64)));
        if (!section.getStringList("Custom-Data").isEmpty()) {
            for (String data : section.getStringList("Custom-Data")) {
                String[] splitData = data.split(":");
                meta.getPersistentDataContainer().set(new NamespacedKey(splitData[0], splitData[1]), PersistentDataType.STRING, (Object)splitData[2]);
            }
        }
        if (section.getBoolean("Glow")) {
            meta.addEnchant(Enchantment.UNBREAKING, 37, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (section.getBoolean("Hide-Tooltip")) {
            meta.setHideTooltip(true);
        }
        if (stack.getType().name().startsWith("LEATHER_") && section.getString("Dye-Color") != null) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
            Color color = ChatColor.of((String)section.getString("Dye-Color", Formatter.colorToChatColor(Bukkit.getServer().getItemFactory().getDefaultLeatherColor()).toString())).getColor();
            leatherArmorMeta.setColor(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            meta = leatherArmorMeta;
        }
        if ((stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.POTION) && (potionSection = section.getConfigurationSection("Potion-Data")) != null) {
            boolean vanilla = potionSection.getBoolean("Vanilla", false);
            PotionMeta potionMeta = (PotionMeta)meta;
            if (potionSection.isSet("Color") && Formatter.getConfig().getHexPattern().pattern().matches(potionSection.getString("Color"))) {
                String hexColor = potionSection.getString("Color");
                int r = Integer.parseInt(hexColor.substring(0, 2), 16);
                int g = Integer.parseInt(hexColor.substring(2, 4), 16);
                int b = Integer.parseInt(hexColor.substring(4, 6), 16);
                potionMeta.setColor(org.bukkit.Color.fromRGB((int)r, (int)g, (int)b));
            }
            String potionType = potionSection.getString("Type", "POISON");
            if (vanilla) {
                potionMeta.setBasePotionType(PotionType.valueOf((String)potionType));
            } else {
                potionMeta.addCustomEffect(new PotionEffect(PotionEffectType.getByName((String)potionType), potionSection.getInt("Duration", 20), potionSection.getInt("Amplifier", 1) - 1), true);
            }
            meta = potionMeta;
        }
        if (stack.getType() == Material.TIPPED_ARROW) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionType(PotionType.valueOf((String)section.getString("Arrow-Type", "POISON")));
            meta = potionMeta;
        }
        if (section.getString("Skull-Name") != null && stack.getType() == Material.PLAYER_HEAD) {
            skullMeta = (SkullMeta)meta;
            skullMeta.setOwner(Formatter.format(section.getString("Skull-Name", "Notch"), new StringModifier[0]));
            meta = skullMeta;
        }
        if (section.getString("Skull-URL") != null) {
            skullMeta = (SkullMeta)meta;
            PlayerProfile skullProfile = Bukkit.createPlayerProfile((String)"Notch");
            PlayerTextures textures = skullProfile.getTextures();
            textures.clear();
            try {
                textures.setSkin(URI.create(section.getString("Skull-URL")).toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            skullProfile.setTextures(textures);
            skullMeta.setOwnerProfile(skullProfile);
            meta = skullMeta;
        }
        if (section.isSet("Glider")) {
            meta.setGlider(section.getBoolean("Glider"));
        }
        if (section.getInt("Model-Data") != 0) {
            meta.setCustomModelData(Integer.valueOf(section.getInt("Model-Data")));
        }
        if (section.getString("Item-Model") != null) {
            String[] itemModelData = section.getString("Item-Model").split(":");
            meta.setItemModel(new NamespacedKey(itemModelData[0], itemModelData[1]));
        }
        if (section.getString("Tooltip-Style") != null) {
            String[] tooltipModel = section.getString("Tooltip-Style").split(":");
            meta.setTooltipStyle(new NamespacedKey(tooltipModel[0], tooltipModel[1]));
        }
        if ((equippableSection = section.getConfigurationSection("Equippable-Options")) != null) {
            EquippableComponent component = meta.getEquippable();
            if (equippableSection.contains("Slot")) {
                component.setSlot(EquipmentSlot.valueOf((String)equippableSection.getString("Slot")));
            }
            if (equippableSection.contains("Model")) {
                String[] model = equippableSection.getString("Model").split(":");
                component.setModel(new NamespacedKey(model[0], model[1]));
            }
            if (equippableSection.contains("Camera-Overlay")) {
                String[] overlay = equippableSection.getString("Camera-Overlay").split(":");
                component.setCameraOverlay(new NamespacedKey(overlay[0], overlay[1]));
            }
            if (equippableSection.contains("Equip-Sound")) {
                component.setEquipSound(Sound.valueOf((String)equippableSection.getString("Equip-Sound")));
            }
            if (equippableSection.contains("Allowed-Entities")) {
                List entityStrings = equippableSection.getStringList("Allowed-Entities");
                ArrayList<EntityType> entities = new ArrayList<EntityType>();
                for (String type : entityStrings) {
                    try {
                        entities.add(EntityType.valueOf((String)type));
                    }
                    catch (IllegalArgumentException ignored) {
                        Bukkit.getLogger().warning("(ItemStackUtil): Skipped invalid EntityType '" + type + "' for EquippableComponent.");
                    }
                }
                component.setAllowedEntities(entities);
            }
            component.setDispensable(equippableSection.getBoolean("Dispensable", false));
            component.setSwappable(equippableSection.getBoolean("Swappable", false));
            component.setDamageOnHurt(equippableSection.getBoolean("Damage-On-Hurt", false));
            meta.setEquippable(component);
        }
        if ((foodSection = section.getConfigurationSection("Food-Options")) != null) {
            FoodComponent component = meta.getFood();
            component.setCanAlwaysEat(foodSection.getBoolean("Can-Always-Eat", component.canAlwaysEat()));
            component.setNutrition(foodSection.getInt("Nutrition", component.getNutrition()));
            component.setSaturation((float)foodSection.getInt("Saturation", (int)component.getSaturation()));
            meta.setFood(component);
        }
        if ((toolSection = section.getConfigurationSection("Tool-Options")) != null) {
            ToolComponent component = meta.getTool();
            component.setDamagePerBlock(toolSection.getInt("Damage-Per-Block", component.getDamagePerBlock()));
            toolSection.getStringList("Rules").forEach(s -> {
                String[] ruleData = s.split(":");
                if (ruleData.length < 3) {
                    return;
                }
                component.addRule(EnumUtil.getValue(Material.class, ruleData[0], Material.OAK_LOG), Float.valueOf(Float.parseFloat(ruleData[1])), Boolean.valueOf(Boolean.parseBoolean(ruleData[2])));
            });
            component.setDefaultMiningSpeed((float)toolSection.getInt("Default-Mining-Speed", (int)component.getDefaultMiningSpeed()));
            meta.setTool(component);
        }
        ItemMeta finalMeta = meta;
        section.getStringList("Enchantments").forEach(enchant -> {
            String[] data = enchant.split(":");
            NamespacedKey key = NamespacedKey.minecraft((String)data[0].trim());
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)key);
            int level = 0;
            if (NumberUtil.isNumber(data[1])) {
                level = Integer.parseInt(data[1]);
            }
            if (enchantment == null) {
                Bukkit.getLogger().warning(String.format("[APIByLogic] (ItemStackUtil): Skipped enchantment '%s', invalid enchant.", enchant));
                return;
            }
            finalMeta.addEnchant(enchantment, level, true);
        });
        for (String flag : section.getStringList("Flags")) {
            finalMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.toUpperCase())});
        }
        stack.setItemMeta(finalMeta);
        ConfigurationSection consumableSection = section.getConfigurationSection("Consumable-Options");
        if (consumableSection != null) {
            if (ServerUtil.isPaper()) {
                PaperConsumableProvider.provide(stack, consumableSection);
            } else {
                ConsumableComponent consumableComponent = meta.getConsumable();
                consumableComponent.setConsumeSeconds((float)consumableSection.getInt("Consume-Seconds", 3));
                consumableComponent.setConsumeParticles(consumableSection.getBoolean("Particles", true));
                if (consumableSection.isSet("Sound")) {
                    consumableComponent.setSound(Sound.valueOf((String)consumableSection.getString("Sound")));
                }
                meta.setConsumable(consumableComponent);
            }
        }
        return Optional.of(stack);
    }

    @Override
    public ConfigurationSection serializeTo(@NonNull ConfigurationSection section, @NonNull ItemStack itemStack) {
        SkullMeta skullMeta;
        PotionMeta potionMeta;
        LeatherArmorMeta leatherArmorMeta;
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        section.set("Material", (Object)itemStack.getType().name());
        section.set("Amount", (Object)itemStack.getAmount());
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return section;
        }
        if (meta.hasDisplayName()) {
            section.set("Name", (Object)Formatter.reverseColors(meta.getDisplayName()));
        }
        if (meta.hasLore() && meta.getLore() != null) {
            ArrayList plainLore = new ArrayList();
            meta.getLore().forEach(loreLine -> plainLore.add(Formatter.reverseColors(loreLine)));
            section.set("Lore", plainLore);
        }
        ArrayList flags = new ArrayList();
        meta.getItemFlags().forEach(itemFlag -> flags.add(itemFlag.name()));
        if (!flags.isEmpty()) {
            section.set("Flags", flags);
        }
        ArrayList<CallSite> customData = new ArrayList<CallSite>();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        for (NamespacedKey key : dataContainer.getKeys()) {
            if (!dataContainer.has(key, PersistentDataType.STRING)) continue;
            customData.add((CallSite)((Object)(key.getNamespace() + ":" + key.getKey() + ":" + (String)dataContainer.get(key, PersistentDataType.STRING))));
        }
        if (!customData.isEmpty()) {
            section.set("Custom-Data", customData);
        }
        if (meta.hasEnchant(Enchantment.UNBREAKING) && meta.getEnchantLevel(Enchantment.UNBREAKING) == 37 && meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
            section.set("Glow", (Object)true);
        }
        if (meta.isHideTooltip()) {
            section.set("Hide-Tooltip", (Object)true);
        }
        if (meta instanceof LeatherArmorMeta && !(leatherArmorMeta = (LeatherArmorMeta)meta).getColor().equals((Object)Bukkit.getServer().getItemFactory().getDefaultLeatherColor())) {
            section.set("Dye-Color", (Object)Formatter.colorToChatColor(leatherArmorMeta.getColor()));
        }
        if (meta instanceof PotionMeta) {
            potionMeta = (PotionMeta)meta;
            if (itemStack.getType() == Material.POTION || itemStack.getType() == Material.SPLASH_POTION || itemStack.getType() == Material.LINGERING_POTION) {
                if (potionMeta.getBasePotionType() != null) {
                    section.set("Potion-Data.Vanilla", (Object)true);
                    section.set("Potion-Data.Type", (Object)potionMeta.getBasePotionType().name());
                } else if (potionMeta.getCustomEffects().size() > 1) {
                    PotionEffect effect = (PotionEffect)potionMeta.getCustomEffects().getFirst();
                    section.set("Potion-Data.Type", (Object)effect.getType().getKey().getKey());
                    section.set("Duration", (Object)effect.getDuration());
                    section.set("Amplifier", (Object)(effect.getAmplifier() + 1));
                }
            }
        }
        if (meta instanceof PotionMeta && (potionMeta = (PotionMeta)meta).getBasePotionType() != null && itemStack.getType() == Material.TIPPED_ARROW) {
            section.set("Arrow-Type", (Object)potionMeta.getBasePotionType().name());
        }
        if (meta instanceof SkullMeta && (skullMeta = (SkullMeta)meta).getOwnerProfile() != null && skullMeta.getOwnerProfile().getTextures().getSkin() != null) {
            section.set("Skull-URL", (Object)skullMeta.getOwnerProfile().getTextures().getSkin().toString());
        }
        if (meta.hasCustomModelData()) {
            section.set("Model-Data", (Object)meta.getCustomModelData());
        }
        ArrayList enchants = new ArrayList();
        meta.getEnchants().forEach((enchantment, integer) -> enchants.add(enchantment.getKey().getKey() + ":" + integer));
        if (!enchants.isEmpty()) {
            section.set("Enchantments", enchants);
        }
        return section;
    }
}

