/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.location;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class SafeLocation
implements Serializable {
    private final String world;
    private final double x;
    private final double y;
    private final double z;

    public static SafeLocation fromString(String string) {
        String[] data = string.split(":");
        return new SafeLocation(data[0], Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3]));
    }

    public static SafeLocation fromBukkitLocation(Location location) {
        return new SafeLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public boolean matches(Location loc) {
        return loc.getWorld().getName().equalsIgnoreCase(this.world) && loc.getX() == this.x && loc.getY() == this.y && loc.getZ() == this.z;
    }

    public Location toBukkitLocation() {
        if (Bukkit.getWorld((String)this.world) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.world, this.x, this.y, this.z);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SafeLocation that = (SafeLocation)object;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.z, that.z) == 0 && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.y, this.z);
    }

    @Generated
    public String getWorld() {
        return this.world;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public SafeLocation(String world, double x, double y, double z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

