/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.location;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.location.ChunkPosition;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public record WorldPosition(@NonNull String worldName, double x, double y, double z) {
    @Generated
    public WorldPosition(@NonNull String worldName, double x, double y, double z) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
    }

    public static WorldPosition of(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return new WorldPosition(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public static WorldPosition ofBlock(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return new WorldPosition(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static WorldPosition of(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        String[] split = string.split(":");
        if (split.length != 4) {
            throw new IllegalArgumentException("Invalid WorldPosition string");
        }
        return new WorldPosition(split[0], Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
    }

    public int getChunkX() {
        return (int)this.x >> 4;
    }

    public int getChunkZ() {
        return (int)this.z >> 4;
    }

    public WorldPosition toWorldBlockPosition() {
        return new WorldPosition(this.worldName, (int)this.x, (int)this.y, (int)this.z);
    }

    public ChunkPosition toChunkPosition() {
        return new ChunkPosition(this.worldName, this.getChunkX(), this.getChunkZ());
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public boolean matches(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.matches(location, true);
    }

    public boolean matches(@NonNull Location location, boolean strict) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (location.getWorld() == null) {
            return false;
        }
        if (!strict) {
            return this.worldName.equals(location.getWorld().getName()) && (int)this.x == location.getBlockX() && (int)this.y == location.getBlockY() && (int)this.z == location.getBlockZ();
        }
        return this.worldName.equals(location.getWorld().getName()) && this.x == location.getX() && this.y == location.getY() && this.z == location.getZ();
    }

    public boolean matches(@NonNull WorldPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.matches(position, true);
    }

    public boolean matches(@NonNull WorldPosition position, boolean strict) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (!strict) {
            return this.worldName.equals(position.worldName()) && (int)this.x == (int)position.x() && (int)this.y == (int)position.y && (int)this.z == (int)position.z;
        }
        return this.worldName.equals(position.worldName()) && this.x == position.x() && this.y == position.y() && this.z == position.z();
    }

    public Optional<Location> toBukkitLocation() {
        World bukkitWorld = Bukkit.getWorld((String)this.worldName);
        if (bukkitWorld == null) {
            return Optional.empty();
        }
        return Optional.of(new Location(bukkitWorld, this.x, this.y, this.z));
    }

    @Override
    @NotNull
    public String toString() {
        return String.format("%s:%s:%s:%s", this.worldName, this.x, this.y, this.z);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldPosition that = (WorldPosition)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.z, that.z) == 0 && Objects.equals(this.worldName, that.worldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.worldName, this.x, this.y, this.z);
    }
}

