/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.message.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.bitbylogic.packetblocks.lib.bitsutils.Placeholder;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.Formatter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Nullable;

public class MessageProvider {
    private final HashMap<String, Object> messages = new HashMap();
    private final List<StringModifier> placeholders = new ArrayList<StringModifier>();

    public MessageProvider(ConfigurationSection config) {
        config.getKeys(true).stream().filter(key -> !(config.get(key) instanceof MemorySection)).forEach(key -> this.messages.put((String)key, config.get(key)));
    }

    public void loadMessages(FileConfiguration config, @Nullable String messagesPath) {
        ConfigurationSection messageSection;
        this.messages.clear();
        FileConfiguration memorySection = config;
        if (messagesPath != null && (messageSection = config.getConfigurationSection(messagesPath)) != null) {
            memorySection = messageSection;
        }
        for (String string : memorySection.getKeys(true)) {
        }
    }

    public void reload(ConfigurationSection section) {
        this.messages.clear();
        section.getKeys(true).stream().filter(key -> !(section.get(key) instanceof MemorySection)).forEach(key -> this.messages.put((String)key, section.get(key)));
    }

    @Deprecated
    public void registerPlaceholder(Placeholder placeholder) {
        this.placeholders.add(placeholder);
    }

    public void registerModifier(StringModifier placeholder) {
        this.placeholders.add(placeholder);
    }

    public String getMessage(String key, Placeholder ... externalPlaceholders) {
        return this.getMessage(key, true, externalPlaceholders);
    }

    public String getMessage(String key, boolean applyPlaceholders, Placeholder ... externalPlaceholders) {
        String rawMessage = this.getRawMessage(key);
        if (rawMessage == null) {
            return null;
        }
        rawMessage = Formatter.format(rawMessage, externalPlaceholders);
        if (applyPlaceholders) {
            rawMessage = Formatter.format(rawMessage, this.placeholders.toArray(new StringModifier[0]));
        }
        return rawMessage;
    }

    public List<String> getMessageList(String key, Placeholder ... externalPlaceholders) {
        return this.getMessageList(key, true, externalPlaceholders);
    }

    public List<String> getMessageList(String key, boolean applyPlaceholders, Placeholder ... externalPlaceholders) {
        List<String> rawList = this.getRawMessageList(key);
        if (rawList == null) {
            return null;
        }
        ArrayList formattedMessages = new ArrayList();
        rawList.forEach(string -> formattedMessages.add(Formatter.format(string, externalPlaceholders)));
        ArrayList<String> finalMessages = new ArrayList<String>();
        if (applyPlaceholders) {
            formattedMessages.forEach(string -> finalMessages.add(Formatter.format(string, this.placeholders.toArray(new StringModifier[0]))));
        }
        return finalMessages;
    }

    public List<String> getRawMessageList(String key) {
        if (!this.messages.containsKey(key)) {
            return null;
        }
        if (!(this.messages.get(key) instanceof List)) {
            return null;
        }
        return (List)this.messages.get(key);
    }

    public String getRawMessage(String key) {
        if (!this.messages.containsKey(key)) {
            return null;
        }
        if (!(this.messages.get(key) instanceof String)) {
            return null;
        }
        return (String)this.messages.get(key);
    }

    public String applyPlaceholders(String text) {
        return Formatter.format(text, this.placeholders.toArray(new StringModifier[0]));
    }

    @Generated
    public HashMap<String, Object> getMessages() {
        return this.messages;
    }

    @Generated
    public List<StringModifier> getPlaceholders() {
        return this.placeholders;
    }
}

