/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.message.format;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.Placeholder;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.TimeConverter;
import net.bitbylogic.packetblocks.lib.bitsutils.message.BitColor;
import net.bitbylogic.packetblocks.lib.bitsutils.message.DefaultFontInfo;
import net.bitbylogic.packetblocks.lib.bitsutils.message.PlayerStringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.FormatCode;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.FormatConfig;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.FormatData;
import net.bitbylogic.rps.client.RedisClient;
import net.bitbylogic.rps.listener.ListenerComponent;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Formatter {
    private static final List<StringModifier> GLOBAL_MODIFIERS = new ArrayList<StringModifier>();
    private static final HashMap<String, Long> MESSAGE_COOLDOWNS = new HashMap();
    private static FormatConfig config;

    public static void registerConfig(@NonNull File configFile) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        config = new FormatConfig(configFile);
    }

    public static void registerGlobalModifier(StringModifier ... modifiers) {
        GLOBAL_MODIFIERS.addAll(Arrays.asList(modifiers));
    }

    public static String color(String message) {
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Matcher matcher = config.getHexPattern().matcher(coloredMessage);
        while (matcher.find()) {
            String hexColor = matcher.group();
            coloredMessage = coloredMessage.replace(hexColor, ChatColor.of((String)hexColor).toString());
        }
        return coloredMessage;
    }

    public static String reverseColors(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        Matcher matcher = config.getSpigotHexPattern().matcher(message);
        while (matcher.find()) {
            String match = matcher.group();
            StringBuilder hexColor = new StringBuilder("#");
            for (int i = 2; i < match.length(); i += 2) {
                hexColor.append(match.charAt(i + 1));
            }
            message = message.replaceFirst(match, hexColor.toString());
        }
        return message.replace("\u00a7", "&");
    }

    public static ChatColor colorToChatColor(@NonNull org.bukkit.Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        return ChatColor.of((String)hex);
    }

    public static String format(String message, StringModifier ... modifiers) {
        return Formatter.format(message, null, modifiers);
    }

    public static String format(String message, @Nullable Player player, StringModifier ... modifiers) {
        String formattedMessage = message;
        for (StringModifier modifier : modifiers) {
            if (modifier instanceof PlayerStringModifier) {
                PlayerStringModifier playerStringModifier = (PlayerStringModifier)modifier;
                playerStringModifier.modify(formattedMessage, player);
                continue;
            }
            formattedMessage = modifier.modify(formattedMessage);
        }
        for (StringModifier globalModifier : GLOBAL_MODIFIERS) {
            if (globalModifier instanceof PlayerStringModifier) {
                PlayerStringModifier playerStringModifier = (PlayerStringModifier)globalModifier;
                playerStringModifier.modify(formattedMessage, player);
                continue;
            }
            formattedMessage = globalModifier.modify(formattedMessage);
        }
        ArrayList<FormatData> formatData = new ArrayList<FormatData>();
        ArrayList<FormatData> temporaryData = new ArrayList<FormatData>();
        temporaryData.add(new FormatData(null, null, null, formattedMessage));
        while (!temporaryData.isEmpty()) {
            FormatData data = (FormatData)temporaryData.removeFirst();
            String stringToAnalyze = data.getContents();
            List<FormatData> newData = Formatter.findFormatMatches(stringToAnalyze);
            if (data.getEntireMatch() != null) {
                newData.forEach(nd -> nd.setParentData(data));
            }
            formatData.addAll(newData);
            temporaryData.addAll(newData);
        }
        formatData.sort((dataOne, dataTwo) -> {
            FormatCode codeOne = dataOne.getCode();
            FormatCode codeTwo = dataTwo.getCode();
            return Integer.compare(codeOne.getPriority(), codeTwo.getPriority());
        });
        for (FormatData data : formatData) {
            formattedMessage = data.format(formattedMessage);
        }
        return Formatter.color(formattedMessage);
    }

    private static List<FormatData> findFormatMatches(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        ArrayList<FormatData> formatData = new ArrayList<FormatData>();
        Matcher matcher = config.getFormatPattern().matcher(string);
        while (matcher.find()) {
            String codeIdentifier = matcher.group(1) == null ? matcher.group(3) : matcher.group(1);
            String codeData = matcher.group(4);
            String text = matcher.group(2) == null ? matcher.group(5) : matcher.group(2);
            FormatCode code = FormatCode.match(codeIdentifier);
            if (code == null) continue;
            formatData.add(new FormatData(matcher.group(), code, codeData, text));
        }
        return formatData;
    }

    public static String autoFormat(String message, Object ... replacements) {
        Matcher placeholderMatcher = config.getPlaceholderPattern().matcher(message);
        int currentIndex = 0;
        while (placeholderMatcher.find() && currentIndex <= replacements.length) {
            String placeholder = placeholderMatcher.group();
            message = message.replace(placeholder, replacements[currentIndex++].toString());
        }
        return Formatter.format(message, new StringModifier[0]);
    }

    public static BaseComponent richFormat(String message, Object ... replacements) {
        return TextComponent.fromLegacy((String)Formatter.replace(message, replacements));
    }

    public static String replace(String message, Object ... replacements) {
        String formattedMessage = message;
        for (Object replacement : replacements) {
            if (replacement instanceof StringModifier) {
                formattedMessage = ((StringModifier)replacement).modify(formattedMessage);
                continue;
            }
            if (!formattedMessage.contains("%s")) continue;
            formattedMessage = formattedMessage.replaceFirst("%s", Matcher.quoteReplacement(replacement.toString()));
        }
        return Formatter.format(formattedMessage, new StringModifier[0]);
    }

    public static String command(String command, String description) {
        return Formatter.replace((String)config.getConfigValue("Command"), new Placeholder("%command%", command), new Placeholder("%description%", description));
    }

    public static BaseComponent richCommand(String command, String description) {
        BaseComponent component = Formatter.richFormat((String)config.getConfigValue("Rich-Format.Text"), new Placeholder("%command%", command));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Formatter.richFormat((String)config.getConfigValue("Rich-Format.Hover"), new Placeholder("%description%", description)))}));
        return component;
    }

    public static String main(String prefix, String message, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("Main"), new Placeholder("%prefix%", prefix), new Placeholder("%message%", Formatter.replace(message, Formatter.applyHighlightColor(BitColor.getColor("primary"), BitColor.getColor("highlight"), replacements))));
    }

    public static String error(String prefix, String message, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("Error"), new Placeholder("%prefix%", prefix), new Placeholder("%message%", Formatter.replace(message, Formatter.applyHighlightColor(BitColor.getColor("error-secondary"), BitColor.getColor("error-highlight"), replacements))));
    }

    public static String success(String prefix, String message, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("Success"), new Placeholder("%prefix%", prefix), new Placeholder("%message%", Formatter.replace(message, Formatter.applyHighlightColor(BitColor.getColor("success-secondary"), BitColor.getColor("success-highlight"), replacements))));
    }

    public static String listHeader(String prefix, String info, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("List.Header"), new Placeholder("%prefix%", prefix), new Placeholder("%info%", Formatter.replace(info, Formatter.applyHighlightColor(BitColor.getColor("secondary"), BitColor.getColor("highlight"), replacements))));
    }

    public static String listItem(String prefix, String message, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("List.Item"), new Placeholder("%prefix%", prefix), new Placeholder("%message%", Formatter.replace(message, Formatter.applyHighlightColor(BitColor.getColor("success-primary"), BitColor.getColor("success-secondary"), replacements))));
    }

    public static String dottedMessage(String prefix, String message, Object ... replacements) {
        return Formatter.replace((String)config.getConfigValue("Dotted-Message"), new Placeholder("%prefix%", prefix), new Placeholder("%message%", Formatter.replace(message, Formatter.applyHighlightColor(BitColor.getColor("success-primary"), BitColor.getColor("success-secondary"), replacements))));
    }

    public static void sendMessage(Player player, String prefix, String message, Placeholder ... placeholders) {
        Object formattedMessage = BitColor.getColor("primary") + "&l" + prefix + " &8\u2022 " + BitColor.getColor("secondary") + message;
        for (Placeholder placeholder : placeholders) {
            formattedMessage = placeholder.modify((String)formattedMessage);
        }
        player.sendMessage(Formatter.format((String)formattedMessage, new StringModifier[0]));
    }

    public static void sendRedisMessage(@NonNull RedisClient redisClient, UUID player, String message) {
        if (redisClient == null) {
            throw new NullPointerException("redisClient is marked non-null but is null");
        }
        redisClient.sendListenerMessage(new ListenerComponent(null, "abl-message").addData("uuid", (Object)player).addData("message", (Object)message));
    }

    public static void sendRawMessage(Player player, String message, Placeholder ... placeholders) {
        String formattedMessage = message;
        for (Placeholder placeholder : placeholders) {
            formattedMessage = placeholder.modify(formattedMessage);
        }
        player.sendMessage(formattedMessage);
    }

    public static void sendCooldownMessage(Player player, String message, String id, String cooldown) {
        if (player == null) {
            return;
        }
        if (MESSAGE_COOLDOWNS.containsKey(id) && MESSAGE_COOLDOWNS.get(id) - System.currentTimeMillis() > 0L) {
            return;
        }
        long cooldownTime = TimeConverter.convert(cooldown);
        MESSAGE_COOLDOWNS.put(id, System.currentTimeMillis() + cooldownTime);
        player.sendMessage(Formatter.format(message, new StringModifier[0]));
    }

    public static Object[] applyHighlightColor(String primaryColor, String highlightColor, Object[] objects) {
        ArrayList<Object> formattedReplacements = new ArrayList<Object>();
        for (Object o : objects) {
            if (o instanceof Placeholder) {
                Placeholder placeholder = (Placeholder)o;
                for (String key : placeholder.getPlaceholderMap().keySet()) {
                    placeholder.getPlaceholderMap().compute(key, (k, value) -> highlightColor + value + primaryColor);
                }
                formattedReplacements.add(o);
                continue;
            }
            formattedReplacements.add(highlightColor + o.toString() + primaryColor);
        }
        return formattedReplacements.toArray();
    }

    public static String[] getPagedList(String header, List<String> data, int page) {
        ArrayList<String> text = new ArrayList<String>();
        int pages = (double)data.size() / 10.0 % 1.0 == 0.0 ? data.size() / 10 : data.size() / 10 + 1;
        int lastPossibleItem = data.size();
        if (page == 0 || page > pages) {
            text.add(Formatter.error(header, (String)config.getConfigValue("Paged.Invalid-Page"), new Object[0]));
            return text.toArray(new String[0]);
        }
        int startingItem = page * 10 - 10;
        int lastItem = Math.min(startingItem + 10, lastPossibleItem);
        text.add(Formatter.main(header, "", new Object[0]));
        for (int i = startingItem; i < lastItem; ++i) {
            String item = data.get(i);
            text.add(Formatter.format((String)config.getConfigValue("Paged.Item"), new Placeholder("%text%", item)));
        }
        text.add(Formatter.format((String)config.getConfigValue("Paged.Footer"), new Placeholder("%current-page%", page), new Placeholder("%pages%", pages)));
        return text.toArray(new String[0]);
    }

    public static String applyGradientToText(String text, String[] colors) {
        int steps = text.length();
        String[] gradientColors = Formatter.generateGradientColors(colors, steps);
        StringBuilder gradientText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String color = gradientColors[i];
            gradientText.append(color).append(ch);
        }
        return gradientText.toString();
    }

    private static String[] generateGradientColors(String[] colors, int steps) {
        ArrayList<String> stylePrefixes = new ArrayList<String>();
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (String color : colors) {
            if (!color.startsWith("&")) {
                colorList.add(Color.decode(color));
                continue;
            }
            stylePrefixes.add(color);
        }
        int numColors = colorList.size();
        String[] gradientColors = new String[steps];
        for (int i = 0; i < steps; ++i) {
            float ratio = (float)i / (float)(steps - 1);
            int segment = Math.min(numColors - 2, (int)(ratio * (float)(numColors - 1)));
            float segmentRatio = ratio * (float)(numColors - 1) - (float)segment;
            Color startColor = (Color)colorList.get(segment);
            Color endColor = (Color)colorList.get(segment + 1);
            int r = (int)((float)startColor.getRed() + segmentRatio * (float)(endColor.getRed() - startColor.getRed()));
            int g = (int)((float)startColor.getGreen() + segmentRatio * (float)(endColor.getGreen() - startColor.getGreen()));
            int b = (int)((float)startColor.getBlue() + segmentRatio * (float)(endColor.getBlue() - startColor.getBlue()));
            StringBuilder formattedColor = new StringBuilder(String.format("#%02X%02X%02X", r, g, b));
            for (String stylePrefix : stylePrefixes) {
                formattedColor.append(stylePrefix);
            }
            gradientColors[i] = formattedColor.toString();
        }
        return gradientColors;
    }

    public static String centerMessage(String message) {
        String sanitizedString = Formatter.color(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : sanitizedString.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l';
                continue;
            }
            DefaultFontInfo fontInfo = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize = isBold ? messagePxSize + fontInfo.getBoldLength() : messagePxSize + fontInfo.getLength();
            ++messagePxSize;
        }
        int centerPixels = (Integer)config.getConfigValue("Center-Pixels");
        int toCompensate = centerPixels - messagePxSize / 2;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return String.valueOf(sb) + "\u00a7r" + message;
    }

    public static void sendCenteredMessages(Player player, String[] lines) {
        for (String line : lines) {
            Formatter.sendCenteredMessage(player, line);
        }
    }

    public static void sendCenteredMessage(Player player, String message) {
        player.sendMessage(Formatter.centerMessage(message));
    }

    @Generated
    public static List<StringModifier> getGLOBAL_MODIFIERS() {
        return GLOBAL_MODIFIERS;
    }

    @Generated
    public static HashMap<String, Long> getMESSAGE_COOLDOWNS() {
        return MESSAGE_COOLDOWNS;
    }

    @Generated
    public static FormatConfig getConfig() {
        return config;
    }
}

