/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.message.messages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.message.messages.MessageGroup;
import net.bitbylogic.packetblocks.lib.bitsutils.message.messages.MessageKey;
import net.bitbylogic.packetblocks.lib.bitsutils.message.messages.MessageRegistry;
import net.bitbylogic.packetblocks.lib.bitsutils.message.progressbar.ProgressBarMessages;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class Messages {
    private static final Map<String, MessageKey> REGISTRY = new LinkedHashMap<String, MessageKey>();
    private static final List<MessageGroup> GROUP_REGISTRY = new ArrayList<MessageGroup>();
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN};

    public static MessageKey register(String path, String defaultValue) {
        MessageKey key = new MessageKey(path, defaultValue);
        REGISTRY.put(path, key);
        return key;
    }

    public static MessageKey register(String path, List<String> defaultValue) {
        MessageKey key = new MessageKey(path, defaultValue);
        REGISTRY.put(path, key);
        return key;
    }

    public static void registerGroup(MessageGroup ... groups) {
        if (groups == null) {
            throw new NullPointerException("groups is marked non-null but is null");
        }
        GROUP_REGISTRY.addAll(Arrays.asList(groups));
    }

    public static Collection<MessageKey> all() {
        return REGISTRY.values();
    }

    public static MessageKey getByPath(String path) {
        return REGISTRY.get(path);
    }

    public static void initialize(@NonNull File messagesFolder) {
        if (messagesFolder == null) {
            throw new NullPointerException("messagesFolder is marked non-null but is null");
        }
        for (MessageRegistry messageRegistry : GROUP_REGISTRY) {
            messageRegistry.register();
        }
        for (Locale locale : SUPPORTED_LOCALES) {
            File localeConfig = new File(messagesFolder, locale.toLanguageTag() + ".yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)localeConfig);
            for (MessageKey key : REGISTRY.values()) {
                Object value;
                if (!config.isSet(key.getPath())) {
                    List<String> valuesToSave = key.getValues();
                    if (valuesToSave.isEmpty()) continue;
                    if (valuesToSave.size() == 1) {
                        config.set(key.getPath(), (Object)valuesToSave.getFirst());
                        continue;
                    }
                    config.set(key.getPath(), valuesToSave);
                    continue;
                }
                if (config.isList(key.getPath())) {
                    value = new ArrayList(config.getStringList(key.getPath()));
                    key.getValues().clear();
                    key.getValues().addAll((Collection<String>)value);
                    continue;
                }
                value = config.getString(key.getPath());
                if (value == null) continue;
                key.getValues().add((String)value);
            }
            try {
                config.save(localeConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Messages.registerGroup(new ProgressBarMessages());
    }
}

