/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import lombok.Generated;
import net.bitbylogic.packetblocks.adapter.BlockBreakAdapter;
import net.bitbylogic.packetblocks.adapter.BlockPlaceAdapter;
import net.bitbylogic.packetblocks.adapter.BlockUpdateAdapter;
import net.bitbylogic.packetblocks.adapter.ChunkLoadAdapter;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.packetblocks.listener.PacketBlockListener;
import net.bitbylogic.packetblocks.util.BoundingBoxes;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PacketBlocks
extends JavaPlugin {
    private static PacketBlocks instance;
    private PacketBlockManager blockManager;

    public void onLoad() {
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        instance = this;
        if (!Bukkit.getServer().getAllowFlight()) {
            this.getLogger().warning("=====================================================");
            this.getLogger().warning("                  !!! WARNING !!!                    ");
            this.getLogger().warning("                                                     ");
            this.getLogger().warning("   'allow-flight' is DISABLED in server.properties!  ");
            this.getLogger().warning("                                                     ");
            this.getLogger().warning("   Players WILL BE KICKED FOR FLYING when standing   ");
            this.getLogger().warning("   on packet/fake blocks created by this plugin.     ");
            this.getLogger().warning("                                                     ");
            this.getLogger().warning("   ACTION REQUIRED:                                  ");
            this.getLogger().warning("   1) Set 'allow-flight: true' in spigot.yml         ");
            this.getLogger().warning("   2) RESTART THE SERVER to apply the change.        ");
            this.getLogger().warning("                                                     ");
            this.getLogger().warning("   NOTE: changes to server.properties are only read  ");
            this.getLogger().warning("   at server startup! A restart is required for this ");
            this.getLogger().warning("   setting to take effect.                           ");
            this.getLogger().warning("                                                     ");
            this.getLogger().warning("=====================================================");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PacketEvents.getAPI().init();
        BoundingBoxes.init(this);
        this.blockManager = new PacketBlockManager(this);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new ChunkLoadAdapter(this.blockManager), PacketListenerPriority.LOWEST);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new BlockPlaceAdapter(this.blockManager), PacketListenerPriority.LOWEST);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new BlockBreakAdapter(this.blockManager), PacketListenerPriority.LOWEST);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new BlockUpdateAdapter(this.blockManager), PacketListenerPriority.LOWEST);
        });
        this.getServer().getPluginManager().registerEvents((Listener)new PacketBlockListener(this.blockManager), (Plugin)this);
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    @Generated
    public PacketBlockManager getBlockManager() {
        return this.blockManager;
    }

    @Generated
    public static PacketBlocks getInstance() {
        return instance;
    }
}

