/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.adapter;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.packetblocks.event.PacketBlockBreakEvent;
import net.bitbylogic.packetblocks.event.PacketBlockStartBreakEvent;
import net.bitbylogic.packetblocks.task.PacketBlockAnimationTask;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockBreakAdapter
implements PacketListener {
    private final PacketBlockManager manager;
    private final PacketBlockAnimationTask task;
    private final Set<UUID> cancelledBreaks;

    public BlockBreakAdapter(@NonNull PacketBlockManager manager) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        this.manager = manager;
        this.task = new PacketBlockAnimationTask();
        this.task.runTaskTimerAsynchronously((Plugin)manager.getPlugin(), 1L, 1L);
        this.cancelledBreaks = new HashSet<UUID>();
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.PLAYER_DIGGING) {
            return;
        }
        Player player = (Player)event.getPlayer();
        WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(event);
        Vector3i position = packet.getBlockPosition();
        Location location = new Location(player.getWorld(), (double)position.getX(), (double)position.getY(), (double)position.getZ());
        Optional<PacketBlock> optionalBlock = this.manager.getBlock(location);
        if (optionalBlock.isEmpty()) {
            return;
        }
        PacketBlock packetBlock = optionalBlock.get();
        if (!packetBlock.isViewer(player)) {
            return;
        }
        int breakSpeed = packetBlock.getBreakSpeed(player);
        float vanillaHardness = packetBlock.getBlockState(player).getType().getHardness();
        switch (packet.getAction()) {
            case START_DIGGING: {
                this.handleStartDestroy(player, packetBlock, location, packet, breakSpeed, vanillaHardness);
                break;
            }
            case CANCELLED_DIGGING: {
                if (breakSpeed == -1) break;
                this.task.removeEntry(player);
                break;
            }
            case FINISHED_DIGGING: {
                this.handleStopDestroy(player, packetBlock, location);
            }
        }
    }

    private void handleStartDestroy(@NonNull Player player, @NonNull PacketBlock packetBlock, @NonNull Location location, @NonNull WrapperPlayClientPlayerDigging packet, int breakSpeed, float vanillaHardness) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (packetBlock == null) {
            throw new NullPointerException("packetBlock is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        Bukkit.getScheduler().runTask((Plugin)PacketBlocks.getInstance(), () -> {
            PacketBlockStartBreakEvent breakStartEvent = new PacketBlockStartBreakEvent(player, packetBlock, location);
            Bukkit.getPluginManager().callEvent((Event)breakStartEvent);
            if (breakStartEvent.isCancelled()) {
                this.cancelledBreaks.add(player.getUniqueId());
                packetBlock.sendUpdate(player);
                PacketEvents.getAPI().getPlayerManager().receivePacket((Object)player, (PacketWrapper)packet);
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE || breakSpeed == -1 && vanillaHardness == 0.0f) {
                this.handleStopDestroy(player, packetBlock, location);
                return;
            }
            if (breakSpeed != -1) {
                this.task.addEntry(player, packetBlock);
            }
        });
    }

    private void handleStopDestroy(@NonNull Player player, @NonNull PacketBlock packetBlock, @NonNull Location location) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (packetBlock == null) {
            throw new NullPointerException("packetBlock is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        Bukkit.getScheduler().runTask((Plugin)PacketBlocks.getInstance(), () -> {
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            PacketBlockBreakEvent breakEvent = new PacketBlockBreakEvent(player, packetBlock, location, heldItem);
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (breakEvent.isCancelled() || this.cancelledBreaks.contains(player.getUniqueId())) {
                this.cancelledBreaks.remove(player.getUniqueId());
                if (breakEvent.isUpdate()) {
                    packetBlock.sendUpdate(player);
                }
                return;
            }
            if (breakEvent.isDropItems()) {
                packetBlock.getBlockState(player).getBlock().getDrops(player.getInventory().getItemInMainHand(), (Entity)player).forEach(drop -> player.getWorld().dropItemNaturally(location, drop));
            }
        });
    }
}

