/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.adapter;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMultiBlockChange;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BlockUpdateAdapter
implements PacketListener {
    private final PacketBlockManager manager;

    public void onPacketSend(PacketSendEvent event) {
        Player player = (Player)event.getPlayer();
        if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
            WrapperPlayServerBlockChange packet = new WrapperPlayServerBlockChange(event);
            Vector3i position = packet.getBlockPosition();
            Location blockPos = new Location(player.getWorld(), (double)position.getX(), (double)position.getY(), (double)position.getZ());
            Location bukkitLoc = new Location(player.getWorld(), blockPos.getX(), blockPos.getY(), blockPos.getZ());
            Optional<PacketBlock> optionalBlock = this.manager.getBlock(bukkitLoc);
            if (optionalBlock.isPresent() && optionalBlock.get().isViewer(player)) {
                PacketBlock block = optionalBlock.get();
                packet.setBlockState(WrappedBlockState.getByString((String)block.getBlockState(player).getBlockData().getAsString()));
            }
        } else if (event.getPacketType() == PacketType.Play.Server.MULTI_BLOCK_CHANGE) {
            WrapperPlayServerMultiBlockChange packet = new WrapperPlayServerMultiBlockChange(event);
            WrapperPlayServerMultiBlockChange.EncodedBlock[] blocks = packet.getBlocks();
            ArrayList<WrapperPlayServerMultiBlockChange.EncodedBlock> modifiedBlocks = new ArrayList<WrapperPlayServerMultiBlockChange.EncodedBlock>();
            for (WrapperPlayServerMultiBlockChange.EncodedBlock block : blocks) {
                Location loc = new Location(player.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
                Optional<PacketBlock> pb = this.manager.getBlock(loc);
                if (pb.isPresent() && pb.get().isViewer(player)) {
                    modifiedBlocks.add(new WrapperPlayServerMultiBlockChange.EncodedBlock(WrappedBlockState.getByString((String)pb.get().getBlockState(player).getBlockData().getAsString()), block.getX(), block.getY(), block.getZ()));
                    continue;
                }
                modifiedBlocks.add(block);
            }
            packet.setBlocks(modifiedBlocks.toArray(new WrapperPlayServerMultiBlockChange.EncodedBlock[0]));
        }
    }

    @Generated
    public BlockUpdateAdapter(PacketBlockManager manager) {
        this.manager = manager;
    }
}

