/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.adapter;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChunkData;
import java.util.ArrayList;
import lombok.Generated;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class ChunkLoadAdapter
implements PacketListener {
    private final PacketBlockManager manager;

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.CHUNK_DATA) {
            return;
        }
        Player player = (Player)event.getPlayer();
        WrapperPlayServerChunkData packet = new WrapperPlayServerChunkData(event);
        int chunkX = packet.getColumn().getX();
        int chunkZ = packet.getColumn().getZ();
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>(this.manager.getBlocks(player.getWorld(), chunkX, chunkZ));
        if (blocks.isEmpty()) {
            return;
        }
        BaseChunk[] sections = packet.getColumn().getChunks();
        int absMinHeight = Math.abs(player.getWorld().getMinHeight());
        for (PacketBlock packetBlock : blocks) {
            BaseChunk section;
            if (!packetBlock.isViewer(player)) continue;
            Location loc = packetBlock.getLocation();
            int xInChunk = loc.getBlockX() & 0xF;
            int y = loc.getBlockY();
            int zInChunk = loc.getBlockZ() & 0xF;
            int sectionIndex = (y >> 4) + (absMinHeight >> 4);
            int yInSection = y & 0xF;
            if (sectionIndex < 0 || sectionIndex >= sections.length || (section = sections[sectionIndex]) == null) continue;
            BlockData bukkitData = packetBlock.getBlockState(player).getBlockData();
            WrappedBlockState wrappedState = WrappedBlockState.getByString((String)bukkitData.getAsString());
            section.set(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), xInChunk, yInSection, zInChunk, wrappedState.getGlobalId());
        }
    }

    @Generated
    public ChunkLoadAdapter(PacketBlockManager manager) {
        this.manager = manager;
    }
}

