/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.lib.bitsutils.location.ChunkPosition;
import net.bitbylogic.packetblocks.lib.bitsutils.location.LocationUtil;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

public class PacketBlockManager {
    private final ConcurrentHashMap<ChunkPosition, List<PacketBlock>> blockLocations = new ConcurrentHashMap();
    private final PacketBlocks plugin;

    public PacketBlock createBlock(@NonNull Location location, @NonNull BlockData blockData) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (blockData == null) {
            throw new NullPointerException("blockData is marked non-null but is null");
        }
        World world = location.getWorld();
        if (world == null) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to create packet block, null world!: " + location.toString());
            return null;
        }
        Chunk chunk = location.getChunk();
        PacketBlock packetBlock = new PacketBlock(location, blockData);
        ChunkPosition identifier = new ChunkPosition(location.getWorld().getName(), chunk.getX(), chunk.getZ());
        if (this.blockLocations.containsKey(identifier)) {
            List<PacketBlock> blocks = this.blockLocations.get(identifier);
            if (blocks.contains(packetBlock)) {
                return packetBlock;
            }
            blocks.add(packetBlock);
            this.blockLocations.put(identifier, blocks);
            return packetBlock;
        }
        ArrayList<PacketBlock> newBlocks = new ArrayList<PacketBlock>();
        newBlocks.add(packetBlock);
        this.blockLocations.put(identifier, newBlocks);
        return packetBlock;
    }

    public void removeBlock(@NonNull PacketBlock packetBlock) {
        if (packetBlock == null) {
            throw new NullPointerException("packetBlock is marked non-null but is null");
        }
        for (Map.Entry<ChunkPosition, List<PacketBlock>> entry : this.blockLocations.entrySet()) {
            List<PacketBlock> blocks = entry.getValue();
            if (!blocks.contains(packetBlock)) continue;
            blocks.remove(packetBlock);
            this.blockLocations.put(entry.getKey(), blocks);
        }
        packetBlock.getViewers().keySet().forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return;
            }
            player.sendBlockChange(packetBlock.getLocation(), packetBlock.getLocation().getBlock().getBlockData());
        });
    }

    public void removeIf(Predicate<PacketBlock> removePredicate) {
        for (Map.Entry<ChunkPosition, List<PacketBlock>> entry : this.blockLocations.entrySet()) {
            List<PacketBlock> blocks = entry.getValue();
            blocks.stream().filter(removePredicate).forEach(packetBlock -> packetBlock.getViewers().keySet().forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.sendBlockChange(packetBlock.getLocation(), packetBlock.getLocation().getBlock().getBlockData()), 1L);
            }));
            blocks.removeIf(removePredicate);
            this.blockLocations.put(entry.getKey(), blocks);
        }
    }

    public Optional<PacketBlock> getBlock(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        World world = location.getWorld();
        if (world == null) {
            return Optional.empty();
        }
        Chunk chunk = location.getChunk();
        return new ArrayList<PacketBlock>(this.getBlocks(world, chunk.getX(), chunk.getZ())).stream().filter(loc -> loc != null && loc.getLocation() != null && LocationUtil.matches(loc.getLocation().toBlockLocation(), location.toBlockLocation())).findFirst();
    }

    public List<PacketBlock> getBlocks(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.values().forEach(packetBlocks -> packetBlocks.forEach(block -> {
            if (block == null || block.getLocation() == null) {
                return;
            }
            World blockWorld = block.getLocation().getWorld();
            if (blockWorld == null || !blockWorld.getName().equalsIgnoreCase(world.getName())) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public List<PacketBlock> getBlocks(@NonNull World world, int chunkX, int chunkZ) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        ChunkPosition chunkIdentifier = new ChunkPosition(world.getName(), chunkX, chunkZ);
        return this.blockLocations.getOrDefault(chunkIdentifier, new ArrayList());
    }

    public List<PacketBlock> getBlocksByViewer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.forEach((identifier, value) -> value.forEach(block -> {
            if (!block.getViewers().containsKey(player.getUniqueId())) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public List<PacketBlock> getBlocksByViewerWithMeta(@NonNull Player player, @NonNull String metaKey) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (metaKey == null) {
            throw new NullPointerException("metaKey is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.forEach((identifier, value) -> value.forEach(block -> {
            if (!block.getViewers().containsKey(player.getUniqueId()) || !block.getMetadata().containsKey(metaKey)) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public List<PacketBlock> getBlocksByMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.forEach((identifier, value) -> value.forEach(block -> {
            if (!block.getMetadata().containsKey(key)) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public List<PacketBlock> getHitBlocks(@NonNull World world, @NonNull BoundingBox boundingBox) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (boundingBox == null) {
            throw new NullPointerException("boundingBox is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.getChunksInBoundingBox(world, boundingBox).forEach(chunk -> this.getBlocks(world, chunk.getX(), chunk.getZ()).forEach(block -> {
            if (!block.getBoundingBox().overlaps(boundingBox)) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public Set<Chunk> getChunksInBoundingBox(World world, BoundingBox box) {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        int minChunkX = (int)Math.floor(box.getMinX()) >> 4;
        int maxChunkX = (int)Math.floor(box.getMaxX()) >> 4;
        int minChunkZ = (int)Math.floor(box.getMinZ()) >> 4;
        int maxChunkZ = (int)Math.floor(box.getMaxZ()) >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.getChunkAt(chunkX, chunkZ);
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public List<PacketBlock> getHitBlocksByViewer(@NonNull Player player, @NonNull BoundingBox boundingBox) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (boundingBox == null) {
            throw new NullPointerException("boundingBox is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.forEach((identifier, value) -> value.forEach(block -> {
            if (!block.getViewers().containsKey(player.getUniqueId())) {
                return;
            }
            BoundingBox box = BoundingBox.of((Location)block.getLocation().clone(), (Location)block.getLocation().clone().add(1.0, 1.0, 1.0));
            if (!box.overlaps(boundingBox)) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public List<PacketBlock> getHitBlocksByViewerWithMeta(@NonNull Player player, @NonNull BoundingBox boundingBox, @NonNull String metaKey) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (boundingBox == null) {
            throw new NullPointerException("boundingBox is marked non-null but is null");
        }
        if (metaKey == null) {
            throw new NullPointerException("metaKey is marked non-null but is null");
        }
        ArrayList<PacketBlock> blocks = new ArrayList<PacketBlock>();
        this.blockLocations.forEach((identifier, value) -> value.forEach(block -> {
            if (!block.getViewers().containsKey(player.getUniqueId())) {
                return;
            }
            if (!block.getMetadata().containsKey(metaKey)) {
                return;
            }
            BoundingBox box = BoundingBox.of((Location)block.getLocation().clone(), (Location)block.getLocation().clone().add(1.0, 1.0, 1.0));
            if (!box.overlaps(boundingBox)) {
                return;
            }
            blocks.add((PacketBlock)block);
        }));
        return blocks;
    }

    public void updateBlocks(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.updateBlocksWithMeta(player, null);
    }

    public void updateBlocksWithMeta(@NonNull Player player, @Nullable String metaKey) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        HashSet states = new HashSet();
        if (metaKey == null) {
            this.getBlocksByViewer(player).forEach(packetBlock -> states.add(packetBlock.getBlockState(player)));
            player.sendBlockChanges(states);
            return;
        }
        this.getBlocksByViewerWithMeta(player, metaKey).forEach(packetBlock -> states.add(packetBlock.getBlockState(player)));
        player.sendBlockChanges(states);
    }

    @Generated
    public PacketBlockManager(PacketBlocks plugin) {
        this.plugin = plugin;
    }

    @Generated
    public ConcurrentHashMap<ChunkPosition, List<PacketBlock>> getBlockLocations() {
        return this.blockLocations;
    }

    @Generated
    public PacketBlocks getPlugin() {
        return this.plugin;
    }
}

