/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.block;

import java.util.HashMap;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.Nullable;

public class PacketBlockPlayerData {
    private final HashMap<String, Object> metadata = new HashMap();
    private BlockData blockData;
    private Supplier<BlockData> blockDataSupplier;
    private int breakSpeed;

    public void addMetadata(@NonNull String key, @NonNull Object object) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (this.metadata.containsKey(key)) {
            return;
        }
        this.metadata.put(key, object);
    }

    public void removeMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.metadata.remove(key);
    }

    public boolean hasMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadata.containsKey(key);
    }

    public Object getMetadata(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getMetadata(key, null);
    }

    public <T> T getMetadataAs(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)this.getMetadata(key, null);
    }

    public Object getMetadata(@NonNull String key, @Nullable Object fallback) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadata.getOrDefault(key, fallback);
    }

    @Generated
    public HashMap<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public BlockData getBlockData() {
        return this.blockData;
    }

    @Generated
    public Supplier<BlockData> getBlockDataSupplier() {
        return this.blockDataSupplier;
    }

    @Generated
    public int getBreakSpeed() {
        return this.breakSpeed;
    }

    @Generated
    public void setBlockData(BlockData blockData) {
        this.blockData = blockData;
    }

    @Generated
    public void setBlockDataSupplier(Supplier<BlockData> blockDataSupplier) {
        this.blockDataSupplier = blockDataSupplier;
    }

    @Generated
    public void setBreakSpeed(int breakSpeed) {
        this.breakSpeed = breakSpeed;
    }

    @Generated
    public PacketBlockPlayerData(BlockData blockData, Supplier<BlockData> blockDataSupplier, int breakSpeed) {
        this.blockData = blockData;
        this.blockDataSupplier = blockDataSupplier;
        this.breakSpeed = breakSpeed;
    }
}

