/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils;

import java.util.HashMap;
import java.util.logging.Logger;
import lombok.Generated;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;

public class Placeholder
implements StringModifier {
    private static final Logger LOGGER = Logger.getLogger("BitsUtils");
    private final HashMap<String, String> placeholderMap = new HashMap();

    public Placeholder(String key, Object value) {
        this.placeholderMap.put(key, value instanceof String ? (String)value : value.toString());
    }

    public Placeholder(String key, String value) {
        this.placeholderMap.put(key, value);
    }

    public Placeholder(String ... replacements) {
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) {
                this.placeholderMap.put(replacements[i], "Invalid Placeholder");
                break;
            }
            this.placeholderMap.put(replacements[i], replacements[i + 1]);
        }
    }

    @Override
    public String modify(String string) {
        String modifiedString = string;
        for (String key : this.placeholderMap.keySet()) {
            if (this.placeholderMap.get(key) == null) {
                LOGGER.warning("Skipping placeholder '" + key + "', mapped to null value.");
                continue;
            }
            modifiedString = modifiedString.replace(key, this.placeholderMap.get(key));
        }
        return modifiedString;
    }

    @Generated
    public HashMap<String, String> getPlaceholderMap() {
        return this.placeholderMap;
    }
}

