/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.action.Action;

public final class ActionRegistry {
    private static final Map<String, Action> ACTIONS = new HashMap<String, Action>();

    private ActionRegistry() {
    }

    public static void register(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (ACTIONS.containsKey(action.getId().toLowerCase())) {
            return;
        }
        ACTIONS.putIfAbsent(action.getId().toLowerCase(), action);
    }

    public static void register(Action ... actions) {
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        for (Action action : actions) {
            if (ACTIONS.containsKey(action.getId().toLowerCase())) {
                return;
            }
            ACTIONS.putIfAbsent(action.getId().toLowerCase(), action);
        }
    }

    public static void unregister(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ACTIONS.remove(id.toLowerCase());
    }

    public static Optional<Action> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable(ACTIONS.get(id.toLowerCase()));
    }

    public static Set<String> getIds() {
        return ACTIONS.keySet();
    }

    public static boolean contains(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ACTIONS.containsKey(id.toLowerCase());
    }

    public static void clear() {
        ACTIONS.clear();
    }
}

