/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.action.impl;

import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.action.Action;
import net.bitbylogic.packetblocks.lib.bitsutils.action.ConfiguredMetadataActionData;
import net.bitbylogic.packetblocks.lib.bitsutils.action.data.ActionData;
import net.bitbylogic.packetblocks.lib.bitsutils.action.data.StringActionData;
import net.bitbylogic.packetblocks.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.packetblocks.lib.bitsutils.context.BukkitContextKeys;
import net.bitbylogic.packetblocks.lib.bitsutils.context.Context;
import net.bitbylogic.packetblocks.lib.bitsutils.context.DefaultContextKeys;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class PlayerSoundAction
implements Action {
    @Override
    public String getId() {
        return "player_sound";
    }

    @Override
    public boolean execute(@NonNull Context context) {
        Sound sound;
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Player player = context.get(BukkitContextKeys.PLAYER).orElse(null);
        if (player == null) {
            return false;
        }
        ActionData actionData = context.get(DefaultContextKeys.ACTION_DATA).orElse(null);
        if (actionData == null) {
            return false;
        }
        float volume = 1.0f;
        float pitch = 1.0f;
        if (actionData instanceof ConfiguredMetadataActionData) {
            ConfiguredMetadataActionData metaData = (ConfiguredMetadataActionData)actionData;
            String soundName = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Sound", "");
            volume = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Volume", Float.valueOf(1.0f)).floatValue();
            pitch = ((ConfiguredMetadata)metaData.getData()).getValueAsOrDefault("Pitch", Float.valueOf(1.0f)).floatValue();
            try {
                sound = Sound.valueOf((String)soundName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (actionData instanceof StringActionData) {
            StringActionData stringData = (StringActionData)actionData;
            String[] parts = ((String)stringData.getData()).split(":");
            try {
                sound = Sound.valueOf((String)parts[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (parts.length >= 2) {
                volume = this.parseFloat(parts[1]);
            }
            if (parts.length >= 3) {
                pitch = this.parseFloat(parts[2]);
            }
        } else {
            return false;
        }
        player.playSound(player.getLocation(), sound, volume, pitch);
        return true;
    }

    private float parseFloat(String str) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    @Override
    public boolean canExecute(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.has(BukkitContextKeys.PLAYER);
    }

    @Generated
    public PlayerSoundAction() {
    }
}

