/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.action.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.action.reference.ActionReference;
import net.bitbylogic.packetblocks.lib.bitsutils.reference.ObjectReference;

public final class ActionReferenceRegistry {
    private static final Map<String, ActionReference> REFERENCES = new HashMap<String, ActionReference>();

    private ActionReferenceRegistry() {
    }

    static void track(@NonNull ActionReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        REFERENCES.put((String)reference.getId(), reference);
    }

    public static ActionReference getAction(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return REFERENCES.get(id);
    }

    public static void untrack(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        REFERENCES.remove(id);
    }

    public static void clear() {
        REFERENCES.clear();
    }

    public static void invalidateAll() {
        REFERENCES.values().forEach(ObjectReference::invalidateCache);
    }

    public static Map<String, ActionReference> all() {
        return Collections.unmodifiableMap(REFERENCES);
    }
}

