/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.config;

import lombok.Generated;
import lombok.NonNull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Nullable;

public class ConfigHelper {
    @Nullable
    private final FileConfiguration config;
    @Nullable
    private final ConfigurationSection section;

    public ConfigHelper(@NonNull FileConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.section = null;
    }

    public ConfigHelper(@NonNull ConfigurationSection section) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        this.config = null;
        this.section = section;
    }

    public void setIfMissing(@NonNull String path, @NonNull Object value) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.config != null && !this.config.contains(path)) {
            this.config.set(path, value);
        }
        if (this.section == null || this.section.contains(path)) {
            return;
        }
        this.section.set(path, value);
    }

    @Nullable
    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Nullable
    @Generated
    public ConfigurationSection getSection() {
        return this.section;
    }

    @Generated
    public ConfigHelper(@Nullable FileConfiguration config, @Nullable ConfigurationSection section) {
        this.config = config;
        this.section = section;
    }
}

