/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.context.ContextKey;

public final class Context {
    private final Map<ContextKey<?>, Object> values = new HashMap();
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public <T> void put(@NonNull ContextKey<T> key, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.values.put(key, value);
    }

    public <T> Optional<T> get(@NonNull ContextKey<T> key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.values.containsKey(key)) {
            try {
                return Optional.ofNullable(this.values.get(key));
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        if (key.getProvider() != null) {
            T value = key.provide(this);
            if (value != null) {
                this.values.put(key, value);
            }
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    public <T> T getOrDefault(@NonNull ContextKey<T> key, @NonNull T defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.values.containsKey(key)) {
            Object value = this.values.get(key);
            return (T)(value == null ? defaultValue : value);
        }
        if (key.getProvider() != null) {
            T value = key.provide(this);
            if (value != null) {
                this.values.put(key, value);
            }
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    public <T> boolean has(@NonNull ContextKey<T> key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.values.containsKey(key);
    }

    public void putAttribute(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.attributes.put(key.toLowerCase(), value);
    }

    public <T> T getAttribute(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.attributes.containsKey(key.toLowerCase())) {
            return (T)this.attributes.get(key.toLowerCase());
        }
        return null;
    }

    public <T> T getAttributeOrDefault(@NonNull String key, @NonNull T defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.attributes.containsKey(key.toLowerCase())) {
            return (T)this.attributes.get(key.toLowerCase());
        }
        return defaultValue;
    }

    public boolean hasAttribute(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.attributes.containsKey(key.toLowerCase());
    }
}

