/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.context;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.context.Context;
import net.bitbylogic.packetblocks.lib.bitsutils.context.registry.ContextRegistry;
import org.jetbrains.annotations.Nullable;

public final class ContextKey<T> {
    @NonNull
    private final String id;
    @NonNull
    private final Class<T> rawType;
    @NonNull
    private final Type genericType;
    @Nullable
    private final Function<Context, T> provider;

    public ContextKey(@NonNull String id, @NonNull Class<T> rawType, @NonNull Type genericType, @Nullable Function<Context, T> provider) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (rawType == null) {
            throw new NullPointerException("rawType is marked non-null but is null");
        }
        if (genericType == null) {
            throw new NullPointerException("genericType is marked non-null but is null");
        }
        this.id = id;
        this.rawType = rawType;
        this.genericType = genericType;
        this.provider = provider;
        ContextRegistry.register(this);
    }

    public ContextKey(@NonNull String id, @NonNull Class<T> rawType, @Nullable Function<Context, T> provider) {
        this(id, rawType, rawType, provider);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (rawType == null) {
            throw new NullPointerException("rawType is marked non-null but is null");
        }
    }

    public ContextKey(@NonNull String id, @NonNull Class<T> rawType, @NonNull Type genericType) {
        this(id, rawType, genericType, null);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (rawType == null) {
            throw new NullPointerException("rawType is marked non-null but is null");
        }
        if (genericType == null) {
            throw new NullPointerException("genericType is marked non-null but is null");
        }
    }

    public ContextKey(@NonNull String id, @NonNull Class<T> rawType) {
        this(id, rawType, rawType, null);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (rawType == null) {
            throw new NullPointerException("rawType is marked non-null but is null");
        }
    }

    public T provide(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.provider == null) {
            throw new IllegalStateException("No provider for key: " + this.id);
        }
        return this.provider.apply(context);
    }

    public static <T> ContextKey<T> key(String id, Class<?> rawType, Type genericType) {
        return new ContextKey(id, rawType, genericType);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContextKey that = (ContextKey)object;
        return Objects.equals(this.id, that.id) && Objects.equals(this.rawType, that.rawType) && Objects.equals(this.genericType, that.genericType) && Objects.equals(this.provider, that.provider);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rawType, this.genericType, this.provider);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Class<T> getRawType() {
        return this.rawType;
    }

    @NonNull
    @Generated
    public Type getGenericType() {
        return this.genericType;
    }

    @Nullable
    @Generated
    public Function<Context, T> getProvider() {
        return this.provider;
    }
}

