/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.cooldown;

import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class Cooldown {
    private final UUID identifier;
    private final String cooldownId;
    private final long timeOfCreation;
    private final long duration;

    public Cooldown(UUID identifier, String cooldownId, long duration) {
        this.identifier = identifier;
        this.cooldownId = cooldownId;
        this.timeOfCreation = System.currentTimeMillis();
        this.duration = duration;
    }

    public boolean isActive() {
        return System.currentTimeMillis() < this.timeOfCreation + this.duration;
    }

    public long getTimeUntilExpired() {
        return this.isActive() ? this.timeOfCreation + this.duration - System.currentTimeMillis() : -1L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Cooldown cooldown = (Cooldown)object;
        return this.timeOfCreation == cooldown.timeOfCreation && this.duration == cooldown.duration && Objects.equals(this.identifier, cooldown.identifier) && Objects.equals(this.cooldownId, cooldown.cooldownId);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.cooldownId, this.timeOfCreation, this.duration);
    }

    @Generated
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getCooldownId() {
        return this.cooldownId;
    }

    @Generated
    public long getTimeOfCreation() {
        return this.timeOfCreation;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }
}

