/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.config.ConfigSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class DirectoryProcessor {
    public static <T> List<T> processDirectory(@NonNull File folder, ConfigSerializer<T> parser) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        return DirectoryProcessor.processDirectory(folder, null, parser);
    }

    public static <T> List<T> processDirectory(@NonNull File folder, @Nullable String baseSection, ConfigSerializer<T> parser) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (!folder.isDirectory()) {
            return new ArrayList();
        }
        return DirectoryProcessor.processDirectory(folder, baseSection, new ArrayList(), parser);
    }

    private static <T> List<T> processDirectory(@NonNull File directory, @Nullable String baseSection, @NonNull List<T> data, ConfigSerializer<T> parser) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (!directory.isDirectory()) {
            return data;
        }
        File[] directoryFiles = directory.listFiles();
        if (directoryFiles == null) {
            return data;
        }
        for (File file : directoryFiles) {
            if (file.isDirectory()) {
                DirectoryProcessor.processDirectory(file, baseSection, data, parser);
                continue;
            }
            DirectoryProcessor.processFile(file, baseSection, data, parser);
        }
        return data;
    }

    private static <T> void processFile(@NonNull File file, @Nullable String baseSection, @NonNull List<T> data, @NonNull ConfigSerializer<T> parser) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (!file.getName().endsWith(".yml")) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (baseSection != null) {
            ConfigurationSection section = config.getConfigurationSection(baseSection);
            if (section == null) {
                return;
            }
            section.getKeys(false).forEach(key -> {
                ConfigurationSection keySection = section.getConfigurationSection(key);
                if (keySection == null) {
                    return;
                }
                parser.serializeFrom(keySection).ifPresent(data::add);
            });
            return;
        }
        parser.serializeFrom((ConfigurationSection)config).ifPresent(data::add);
    }
}

