/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.hologram.HologramLine;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Hologram {
    private static final NamespacedKey HOLOGRAM_KEY = new NamespacedKey("bitsutils", "hologram");
    private final List<HologramLine<?, ?>> lines = new ArrayList();
    private float lineSpacing = 0.17f;
    private boolean persistent;
    private boolean global = true;
    private Location location;
    private int taskId = -1;

    public Hologram(@NonNull HologramLine<?, ?> hologramLine) {
        if (hologramLine == null) {
            throw new NullPointerException("hologramLine is marked non-null but is null");
        }
        this.lines.add(hologramLine);
    }

    public Hologram addLine(@NonNull HologramLine<?, ?> line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        this.lines.add(line);
        return this;
    }

    public Hologram global(boolean global) {
        this.global = global;
        return this;
    }

    public Hologram persistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public Hologram lineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public Hologram schedule(@NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (this.taskId != -1) {
            return this;
        }
        this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
            if (this.lines.isEmpty()) {
                return;
            }
            this.lines.forEach(hologramLine -> {
                if (hologramLine.getLastUpdateTime() != 0L && System.currentTimeMillis() - hologramLine.getLastUpdateTime() < hologramLine.getUpdateInterval()) {
                    return;
                }
                hologramLine.setLastUpdateTime(System.currentTimeMillis());
                hologramLine.updateData();
                this.updateSpacing();
            });
        }, 0L, 1L).getTaskId();
        return this;
    }

    public void spawn(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.spawn(location, null, new ArrayList<Player>());
    }

    public void spawn(@NonNull Location location, @Nullable JavaPlugin plugin, @NonNull List<Player> viewers) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (viewers == null) {
            throw new NullPointerException("viewers is marked non-null but is null");
        }
        this.location = location;
        Display display = null;
        SequencedCollection<HologramLine<Object, Object>> sortedLines = new ArrayList(this.lines);
        sortedLines = sortedLines.reversed();
        for (int i = 0; i < sortedLines.size(); ++i) {
            HologramLine line = (HologramLine)sortedLines.get(i);
            if (display != null) {
                Display lineDisplay = line.build(location, this.persistent, this.global);
                lineDisplay.getPersistentDataContainer().set(HOLOGRAM_KEY, PersistentDataType.BOOLEAN, (Object)true);
                Transformation transformation = lineDisplay.getTransformation();
                transformation.getTranslation().set(0.0f, transformation.getTranslation().y + this.lineSpacing * (float)i, 0.0f);
                line.setLineOffset(new Vector3f((Vector3fc)transformation.getTranslation()));
                lineDisplay.setTransformation(transformation);
                if (!this.global && plugin != null) {
                    viewers.forEach(player -> player.showEntity((Plugin)plugin, (Entity)lineDisplay));
                }
                display = lineDisplay;
                continue;
            }
            display = line.build(location, this.persistent, this.global);
            display.getPersistentDataContainer().set(HOLOGRAM_KEY, PersistentDataType.BOOLEAN, (Object)true);
            if (this.global || plugin == null) continue;
            Display finalDisplay = display;
            viewers.forEach(player -> player.showEntity((Plugin)plugin, (Entity)finalDisplay));
        }
    }

    public void teleport(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        for (HologramLine<?, ?> line : this.lines) {
            if (line.getDisplay() == null) continue;
            line.getDisplay().teleport(location);
        }
    }

    public void updateSpacing() {
        SequencedCollection<HologramLine<Object, Object>> sortedLines = new ArrayList(this.lines);
        sortedLines = sortedLines.reversed();
        float currentY = 0.0f;
        for (HologramLine hologramLine : sortedLines) {
            if (hologramLine.getDisplay() == null && this.location != null) {
                hologramLine.build(this.location, this.persistent, this.global);
            }
            if (hologramLine.getDisplay() == null) continue;
            Display display = hologramLine.getDisplay();
            Transformation transformation = display.getTransformation();
            int lineCount = 1;
            if (display instanceof TextDisplay) {
                TextDisplay textDisplay = (TextDisplay)display;
                String text = Objects.requireNonNullElse(textDisplay.getText(), "");
                lineCount = text.split("\n").length;
            }
            transformation.getTranslation().set(0.0f, currentY, 0.0f);
            display.setTransformation(transformation);
            hologramLine.setLineOffset(new Vector3f((Vector3fc)transformation.getTranslation()));
            currentY += this.lineSpacing * (float)lineCount;
        }
    }

    public boolean cleanup() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        if (this.lines.isEmpty()) {
            return false;
        }
        this.lines.stream().filter(hologramLine -> hologramLine.getDisplay() != null).forEach(hologramLine -> hologramLine.getDisplay().remove());
        return true;
    }

    public Optional<HologramLine<?, ?>> getLine(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.lines.stream().filter(line -> line.getId().equalsIgnoreCase(id)).findFirst();
    }

    public Optional<Display> getTop() {
        return this.lines.isEmpty() ? Optional.empty() : Optional.of(this.lines.getLast().getDisplay());
    }

    public Optional<Display> getBase() {
        return this.lines.isEmpty() ? Optional.empty() : Optional.of(this.lines.getFirst().getDisplay());
    }

    public static boolean isHologram(@NonNull Display display) {
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        return display.getPersistentDataContainer().has(HOLOGRAM_KEY, PersistentDataType.BOOLEAN);
    }

    @Generated
    public List<HologramLine<?, ?>> getLines() {
        return this.lines;
    }
}

