/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.inventory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.bitbylogic.packetblocks.lib.bitsutils.item.ItemStackUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    public static Inventory getViewInventory(InventoryEvent event, String methodName) {
        try {
            InventoryView view = event.getView();
            Method getTopInventory = view.getClass().getMethod(methodName, new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSpace(Inventory inventory) {
        return InventoryUtil.hasSpace(inventory, null, new ArrayList<Integer>());
    }

    public static boolean hasSpace(Inventory inventory, @Nullable ItemStack itemStack) {
        return InventoryUtil.hasSpace(inventory, itemStack, new ArrayList<Integer>());
    }

    public static boolean hasSpace(Inventory inventory, @Nullable ItemStack itemStack, @Nullable List<Integer> validSlots) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return validSlots == null || validSlots.isEmpty() ? inventory.firstEmpty() != -1 : validSlots.stream().anyMatch(slot -> inventory.getItem(slot.intValue()) == null);
        }
        int maxStackSize = itemStack.getMaxStackSize();
        int availableSpace = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            int space;
            if (validSlots != null && !validSlots.isEmpty() && !validSlots.contains(i) || inventory instanceof PlayerInventory && (i >= 36 && i <= 39 || i == 40)) continue;
            ItemStack content = inventory.getItem(i);
            if (content == null || content.getType() == Material.AIR) {
                availableSpace += maxStackSize;
                continue;
            }
            if (!ItemStackUtil.isSimilar(itemStack, content, true, true, true) || (space = content.getMaxStackSize() - content.getAmount()) <= 0) continue;
            availableSpace += space;
        }
        return availableSpace >= itemStack.getAmount();
    }

    public static int getAvailableSpace(Inventory inventory) {
        return InventoryUtil.getAvailableSpace(inventory, null, new ArrayList<Integer>());
    }

    public static int getAvailableSpace(Inventory inventory, @Nullable ItemStack itemStack) {
        return InventoryUtil.getAvailableSpace(inventory, itemStack, new ArrayList<Integer>());
    }

    public static int getAvailableSpace(Inventory inventory, @Nullable ItemStack itemStack, @Nullable List<Integer> validSlots) {
        int maxStackSize = itemStack == null ? -1 : itemStack.getMaxStackSize();
        int availableSpace = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (validSlots != null && !validSlots.isEmpty() && !validSlots.contains(i)) continue;
            ItemStack content = inventory.getItem(i);
            if (content == null || content.getType() == Material.AIR) {
                availableSpace += maxStackSize == -1 ? 64 : maxStackSize;
                continue;
            }
            if (maxStackSize == -1 || !ItemStackUtil.isSimilar(itemStack, content, true, true, true) || content.getAmount() >= maxStackSize) continue;
            availableSpace += content.getMaxStackSize() - content.getAmount();
        }
        return availableSpace;
    }

    public static int getNextAvailableSlot(Inventory inventory) {
        return InventoryUtil.getNextAvailableSlot(inventory, null, null);
    }

    public static int getNextAvailableSlot(Inventory inventory, @Nullable ItemStack itemStack) {
        return InventoryUtil.getNextAvailableSlot(inventory, itemStack, null);
    }

    public static int getNextAvailableSlot(Inventory inventory, @Nullable ItemStack itemStack, @Nullable List<Integer> validSlots) {
        if (!InventoryUtil.hasSpace(inventory, itemStack, validSlots)) {
            return -1;
        }
        int maxStackSize = itemStack == null ? -1 : itemStack.getMaxStackSize();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (validSlots != null && !validSlots.isEmpty() && !validSlots.contains(i)) continue;
            ItemStack content = inventory.getItem(i);
            if (content == null || content.getType() == Material.AIR) {
                return i;
            }
            if (maxStackSize == -1 || !ItemStackUtil.isSimilar(itemStack, content, true, true, true) || content.getAmount() >= maxStackSize) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasItems(Inventory inventory, ItemStack itemStack, int amount, boolean compareFlags, boolean compareName, boolean compareLore, boolean compareDurability) {
        if (itemStack == null) {
            return false;
        }
        AtomicInteger currentSlot = new AtomicInteger(0);
        Inventory testInv = Bukkit.createInventory(null, (int)(inventory instanceof PlayerInventory ? 36 : inventory.getSize()));
        ItemStack[] contents = (ItemStack[])inventory.getContents().clone();
        if (inventory instanceof PlayerInventory) {
            contents[contents.length - 2] = null;
            contents[contents.length - 3] = null;
            contents[contents.length - 4] = null;
            contents[contents.length - 5] = null;
        }
        Arrays.stream(contents).filter(Objects::nonNull).forEach(invItem -> {
            ItemStack clonedItem = invItem.clone();
            testInv.setItem(currentSlot.getAndIncrement(), clonedItem);
        });
        int found = 0;
        for (ItemStack item : testInv.getContents()) {
            if (item == null || item.getType() == Material.AIR || !ItemStackUtil.isSimilar(item, itemStack, compareFlags, compareName, compareLore)) continue;
            if (itemStack.getType() == Material.SPAWNER && ItemStackUtil.spawnerMatches(itemStack, item)) {
                found += item.getAmount();
                continue;
            }
            if (compareDurability && item.getDurability() == itemStack.getDurability()) {
                found += item.getAmount();
                continue;
            }
            found += item.getAmount();
        }
        return found >= amount;
    }

    public static boolean hasItems(Inventory inventory, ItemStack itemStack, int amount) {
        return InventoryUtil.hasItems(inventory, itemStack, amount, false, false, false, false);
    }

    public static int getItems(Inventory inventory, ItemStack itemStack, boolean compareFlags, boolean compareName, boolean compareLore, boolean compareDurability) {
        if (itemStack == null) {
            return 0;
        }
        AtomicInteger currentSlot = new AtomicInteger(0);
        Inventory testInv = Bukkit.createInventory(null, (int)(inventory instanceof PlayerInventory ? 36 : inventory.getSize()));
        ItemStack[] contents = (ItemStack[])inventory.getContents().clone();
        if (inventory instanceof PlayerInventory) {
            contents[contents.length - 2] = null;
            contents[contents.length - 3] = null;
            contents[contents.length - 4] = null;
            contents[contents.length - 5] = null;
        }
        Arrays.stream(contents).filter(Objects::nonNull).forEach(invItem -> {
            ItemStack clonedItem = invItem.clone();
            testInv.setItem(currentSlot.getAndIncrement(), clonedItem);
        });
        int found = 0;
        for (ItemStack item : testInv.getContents()) {
            if (item == null || item.getType() == Material.AIR || !ItemStackUtil.isSimilar(item, itemStack, compareFlags, compareName, compareLore)) continue;
            if (itemStack.getType() == Material.SPAWNER && ItemStackUtil.spawnerMatches(itemStack, item)) {
                found += item.getAmount();
                continue;
            }
            if (compareDurability && item.getDurability() == itemStack.getDurability()) {
                found += item.getAmount();
                continue;
            }
            found += item.getAmount();
        }
        return found;
    }

    public static int getItems(Inventory inventory, ItemStack itemStack) {
        return InventoryUtil.getItems(inventory, itemStack, false, false, false, false);
    }

    public static void addItem(Inventory inventory, ItemStack itemStack) {
        InventoryUtil.addItem(inventory, itemStack, null);
    }

    public static void addItem(Inventory inventory, ItemStack itemStack, @Nullable List<Integer> validSlots) {
        if (!InventoryUtil.hasSpace(inventory, itemStack, validSlots)) {
            return;
        }
        ItemStack clonedStack = itemStack.clone();
        int maxStackSize = itemStack.getMaxStackSize();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (validSlots != null && !validSlots.isEmpty() && !validSlots.contains(i)) continue;
            if (clonedStack == null) break;
            ItemStack content = inventory.getItem(i);
            if (content == null || content.getType() == Material.AIR) {
                ItemStack newItem;
                if (clonedStack.getAmount() > maxStackSize) {
                    newItem = clonedStack.clone();
                    newItem.setAmount(maxStackSize);
                    clonedStack.setAmount(clonedStack.getAmount() - maxStackSize);
                } else {
                    newItem = clonedStack.clone();
                    clonedStack = null;
                }
                inventory.setItem(i, newItem);
                continue;
            }
            if (maxStackSize == -1 || !ItemStackUtil.isSimilar(itemStack, content, true, true, true) || content.getAmount() >= maxStackSize) continue;
            int maxAvailable = maxStackSize - content.getAmount();
            int newAmount = Math.min(maxAvailable, clonedStack.getAmount());
            content.setAmount(content.getAmount() + newAmount);
            if (clonedStack.getAmount() - newAmount <= 0) {
                clonedStack = null;
                continue;
            }
            clonedStack.setAmount(clonedStack.getAmount() - newAmount);
        }
    }

    public static boolean removeMaterial(Player player, Material material, int amount) {
        PlayerInventory inv = player.getInventory();
        int toRemove = amount;
        for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() != material) continue;
            int stackAmount = item.getAmount();
            if (stackAmount <= toRemove) {
                inv.removeItem(new ItemStack[]{item});
                toRemove -= stackAmount;
            } else {
                item.setAmount(stackAmount - toRemove);
                toRemove = 0;
            }
            if (toRemove <= 0) break;
        }
        return toRemove == 0;
    }
}

