/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.location;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public record ChunkPosition(@NonNull String world, int x, int z) {
    @Generated
    public ChunkPosition(@NonNull String world, int x, int z) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
    }

    public Optional<Chunk> toBukkitChunk() {
        World bukkitWorld = Bukkit.getWorld((String)this.world);
        if (bukkitWorld == null) {
            return Optional.empty();
        }
        return Optional.of(bukkitWorld.getChunkAt(this.x, this.z));
    }

    public static ChunkPosition of(@NonNull Chunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        return new ChunkPosition(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPosition that = (ChunkPosition)o;
        return this.x == that.x && this.z == that.z && Objects.equals(this.world, that.world);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }
}

