/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.location;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LocationUtil {
    public static String locationToString(Location location) {
        return LocationUtil.locationToString(location, ":");
    }

    public static String locationToStringWithYawPitch(Location location) {
        return LocationUtil.locationToStringWithYawPitch(location, ":");
    }

    public static String locationToString(Location location, String separator) {
        return location.getWorld().getName() + separator + location.getBlockX() + separator + location.getBlockY() + separator + location.getBlockZ();
    }

    public static String locationToStringWithYawPitch(Location location, String separator) {
        return location.getWorld().getName() + separator + location.getBlockX() + separator + location.getBlockY() + separator + location.getBlockZ() + separator + location.getYaw() + separator + location.getPitch();
    }

    public static Location stringToLocation(String string) {
        return LocationUtil.stringToLocation(string, ":");
    }

    public static Location stringToLocation(String string, String separator) {
        String[] splitArgs = string.split(separator);
        if (splitArgs.length == 4) {
            return new Location(Bukkit.getWorld((String)splitArgs[0]), Double.parseDouble(splitArgs[1]), Double.parseDouble(splitArgs[2]), Double.parseDouble(splitArgs[3]));
        }
        return new Location(Bukkit.getWorld((String)splitArgs[0]), Double.parseDouble(splitArgs[1]), Double.parseDouble(splitArgs[2]), Double.parseDouble(splitArgs[3]), Float.parseFloat(splitArgs[4]), Float.parseFloat(splitArgs[5]));
    }

    public static boolean isLocationString(String string) {
        return LocationUtil.isLocationString(string, ":");
    }

    public static boolean isLocationString(String string, String separator) {
        return string.split(separator).length >= 4;
    }

    public static boolean matches(Location location, Location other) {
        if (location.getWorld() == null || other.getWorld() == null) {
            return false;
        }
        if (!location.getWorld().getName().equalsIgnoreCase(other.getWorld().getName())) {
            return false;
        }
        return location.getX() == other.getX() && location.getY() == other.getY() && location.getZ() == other.getZ();
    }

    public static HashMap<Location, PersistentDataContainer> getAllPersistentData(Chunk chunk) {
        HashMap<Location, PersistentDataContainer> data = new HashMap<Location, PersistentDataContainer>();
        PersistentDataContainer dataContainer = chunk.getPersistentDataContainer();
        if (dataContainer.isEmpty()) {
            return data;
        }
        dataContainer.getKeys().forEach(key -> {
            if (!LocationUtil.isLocationString(key.getKey(), "._.")) {
                return;
            }
            if (dataContainer.get(key, PersistentDataType.TAG_CONTAINER) == null) {
                return;
            }
            data.put(LocationUtil.stringToLocation(key.getKey(), "._."), (PersistentDataContainer)dataContainer.get(key, PersistentDataType.TAG_CONTAINER));
        });
        return data;
    }

    public static boolean hasPersistentData(JavaPlugin plugin, Location location) {
        return location.getChunk().getPersistentDataContainer().has(new NamespacedKey((Plugin)plugin, LocationUtil.locationToString(location, "._.")), PersistentDataType.TAG_CONTAINER);
    }

    public static PersistentDataContainer getPersistentData(JavaPlugin plugin, Location location, boolean create) {
        NamespacedKey locationKey = new NamespacedKey((Plugin)plugin, LocationUtil.locationToString(location, "._."));
        Chunk chunk = location.getChunk();
        if (!chunk.getPersistentDataContainer().has(locationKey, PersistentDataType.TAG_CONTAINER)) {
            if (!create) {
                return null;
            }
            chunk.getPersistentDataContainer().set(locationKey, PersistentDataType.TAG_CONTAINER, (Object)chunk.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        }
        return (PersistentDataContainer)chunk.getPersistentDataContainer().get(locationKey, PersistentDataType.TAG_CONTAINER);
    }

    public static void deletePersistentData(JavaPlugin plugin, Location location) {
        NamespacedKey locationKey = new NamespacedKey((Plugin)plugin, LocationUtil.locationToString(location, "._."));
        Chunk chunk = location.getChunk();
        if (!chunk.getPersistentDataContainer().has(locationKey, PersistentDataType.TAG_CONTAINER)) {
            return;
        }
        chunk.getPersistentDataContainer().remove(locationKey);
    }

    public static void savePersistentData(JavaPlugin plugin, Location location, PersistentDataContainer container) {
        location.getChunk().getPersistentDataContainer().set(new NamespacedKey((Plugin)plugin, LocationUtil.locationToString(location, "._.")), PersistentDataType.TAG_CONTAINER, (Object)container);
    }

    public static int getHighestBlockY(World world, int x, int z) {
        int currentY = world.getMaxHeight();
        int minY = world.getMinHeight();
        world.getChunkAt(x, z);
        for (int y = currentY; y > minY; --y) {
            if (world.getBlockAt(x, y, z).getType().isAir()) continue;
            return y;
        }
        return 0;
    }

    public static Set<Location> locationsBetweenTwoPoints(Location cornerA, Location cornerB) {
        HashSet<Location> locations = new HashSet<Location>();
        int topBlockX = Math.max(cornerA.getBlockX(), cornerB.getBlockX());
        int topBlockY = Math.max(cornerA.getBlockY(), cornerB.getBlockY());
        int topBlockZ = Math.max(cornerA.getBlockZ(), cornerB.getBlockZ());
        int bottomBlockX = Math.min(cornerA.getBlockX(), cornerB.getBlockX());
        int bottomBlockY = Math.min(cornerA.getBlockY(), cornerB.getBlockY());
        int bottomBlockZ = Math.min(cornerA.getBlockZ(), cornerB.getBlockZ());
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    locations.add(new Location(cornerA.getWorld(), (double)x, (double)y, (double)z));
                }
            }
        }
        return locations;
    }

    public static boolean isInside(Location cornerA, Location cornerB, Location location) {
        double minX = Math.min(cornerA.getX(), cornerB.getX());
        double maxX = Math.max(cornerA.getX(), cornerB.getX());
        double minY = Math.min(cornerA.getY(), cornerB.getY());
        double maxY = Math.max(cornerA.getY(), cornerB.getY());
        double minZ = Math.min(cornerA.getZ(), cornerB.getZ());
        double maxZ = Math.max(cornerA.getZ(), cornerB.getZ());
        return location.getX() >= minX && location.getX() <= maxX && location.getY() >= minY && location.getY() <= maxY && location.getZ() >= minZ && location.getZ() <= maxZ;
    }

    public static Location toBlockLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        Location blockLocation = location.clone();
        blockLocation.setX((double)location.getBlockX());
        blockLocation.setY((double)location.getBlockY());
        blockLocation.setZ((double)location.getBlockZ());
        return location;
    }

    public static double distance(@NonNull Location location, @NonNull Location other) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        double dx = location.getX() - other.getX();
        double dy = location.getY() - other.getY();
        double dz = location.getZ() - other.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static Location getCenterBetween(@NonNull Location location, @NonNull Location other) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        double centerX = (location.getX() + other.getX()) / 2.0;
        double centerY = (location.getY() + other.getY()) / 2.0;
        double centerZ = (location.getZ() + other.getZ()) / 2.0;
        return new Location(location.getWorld(), centerX, centerY, centerZ);
    }
}

