/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.location;

import java.util.Optional;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.config.ConfigSerializer;
import net.bitbylogic.packetblocks.lib.bitsutils.location.OffsetLocation;
import org.bukkit.configuration.ConfigurationSection;

public class OffsetLocationConfigSerializer
implements ConfigSerializer<OffsetLocation> {
    @Override
    public Optional<OffsetLocation> serializeFrom(@NonNull ConfigurationSection section) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        double xOffset = section.getDouble("X-Offset");
        double yOffset = section.getDouble("Y-Offset");
        double zOffset = section.getDouble("Z-Offset");
        return Optional.of(new OffsetLocation(xOffset, yOffset, zOffset));
    }

    @Override
    public ConfigurationSection serializeTo(@NonNull ConfigurationSection section, @NonNull OffsetLocation location) {
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Not implemented");
    }
}

