/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.message.format;

import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.message.BitColor;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.FormatCode;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.Formatter;
import net.md_5.bungee.api.ChatColor;

public class FormatData {
    private final FormatCode code;
    private final String codeData;
    private String entireMatch;
    private String contents;
    private FormatData parentData;

    public FormatData(String entireMatch, FormatCode code, String codeData, String contents) {
        this.entireMatch = entireMatch;
        this.code = code;
        this.codeData = codeData;
        this.contents = contents;
    }

    public String format(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        switch (this.code) {
            case COLOR: {
                String color = BitColor.getColor(this.codeData);
                if (color == null) break;
                this.contents = this.entireMatch.replace(this.entireMatch, color + this.contents);
                break;
            }
            case HEX: {
                if (this.codeData == null) break;
                this.contents = this.entireMatch.replace(this.entireMatch, ChatColor.of((String)this.codeData).toString() + this.contents);
                break;
            }
            case GRADIENT: {
                if (this.codeData == null) break;
                ArrayList<String> colors = new ArrayList<String>(Arrays.asList(this.codeData.split(",")));
                this.contents = this.entireMatch.replace(this.entireMatch, Formatter.color(Formatter.applyGradientToText(this.contents, colors.toArray(new String[0]))));
                break;
            }
            case CENTER: {
                this.contents = this.entireMatch.replace(this.entireMatch, Formatter.centerMessage(this.contents));
            }
        }
        if (this.parentData != null) {
            this.parentData.setEntireMatch(this.parentData.getEntireMatch().replace(this.entireMatch, this.contents));
            this.parentData.setContents(this.parentData.getContents().replace(this.entireMatch, this.contents));
        }
        return string.replace(this.entireMatch, this.contents);
    }

    @Generated
    public FormatCode getCode() {
        return this.code;
    }

    @Generated
    public String getCodeData() {
        return this.codeData;
    }

    @Generated
    public String getEntireMatch() {
        return this.entireMatch;
    }

    @Generated
    public String getContents() {
        return this.contents;
    }

    @Generated
    public FormatData getParentData() {
        return this.parentData;
    }

    @Generated
    public void setEntireMatch(String entireMatch) {
        this.entireMatch = entireMatch;
    }

    @Generated
    public void setContents(String contents) {
        this.contents = contents;
    }

    @Generated
    public void setParentData(FormatData parentData) {
        this.parentData = parentData;
    }
}

