/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.message.structured;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.StringModifier;
import net.bitbylogic.packetblocks.lib.bitsutils.message.format.Formatter;
import net.bitbylogic.packetblocks.lib.bitsutils.message.structured.StructuredMessage;
import net.bitbylogic.packetblocks.lib.bitsutils.smallcaps.SmallCapsConverter;

public class StructuredMessageBuilder {
    private static final String ENTRY_PREFIX = "&8&l\u23b8";
    private static final String ENDING_ENTRY_PREFIX = "&8\u23a3";
    private static final String REENTRY_PREFIX = "&8\u23a1";
    private static final String SECTION_MESSAGE = "%s <c#success_primary>%s</c>";
    private static final String ENTRY_MESSAGE = "%s <c#success_primary>%s</c>&8: <c#success_secondary>%s</c>";
    private static final int MAX_ENTRIES_PER_PAGE = 10;
    private final Map<Integer, List<String>> pages = new HashMap<Integer, List<String>>();
    private final String header;
    private int depth;

    public StructuredMessageBuilder(@NonNull String header) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        this.header = header;
    }

    public StructuredMessageBuilder(@NonNull String headerPrefix, @NonNull String headerMessage) {
        if (headerPrefix == null) {
            throw new NullPointerException("headerPrefix is marked non-null but is null");
        }
        if (headerMessage == null) {
            throw new NullPointerException("headerMessage is marked non-null but is null");
        }
        this.header = Formatter.main(SmallCapsConverter.convert(headerPrefix), SmallCapsConverter.convert(headerMessage), new Object[0]);
    }

    public StructuredMessageBuilder sectionUp(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        int newDepth = Math.max(0, this.depth - 1);
        String prefix = " " + "  ".repeat(newDepth) + (newDepth < this.depth ? REENTRY_PREFIX : ENTRY_PREFIX);
        this.depth = newDepth;
        return this.newEntry(String.format(SECTION_MESSAGE, prefix, SmallCapsConverter.convert(key)));
    }

    public StructuredMessageBuilder entryUp(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int newDepth = Math.max(0, this.depth - 1);
        String prefix = " " + "  ".repeat(newDepth) + (newDepth < this.depth ? REENTRY_PREFIX : ENTRY_PREFIX);
        this.depth = newDepth;
        return this.newEntry(String.format(ENTRY_MESSAGE, prefix, SmallCapsConverter.convert(key), value));
    }

    public StructuredMessageBuilder rawEntryUp(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        int newDepth = Math.max(0, this.depth - 1);
        String prefix = " " + "  ".repeat(newDepth) + (newDepth < this.depth ? REENTRY_PREFIX : ENTRY_PREFIX);
        this.depth = newDepth;
        return this.newEntry(prefix + " " + message);
    }

    public StructuredMessageBuilder sectionDown(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        int newDepth = this.depth + 1;
        String prefix = " " + "  ".repeat(this.depth) + ENDING_ENTRY_PREFIX;
        this.depth = newDepth;
        return this.newEntry(String.format(SECTION_MESSAGE, prefix, SmallCapsConverter.convert(key)));
    }

    public StructuredMessageBuilder entryDown(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        int newDepth = this.depth + 1;
        String prefix = " " + "  ".repeat(this.depth) + ENDING_ENTRY_PREFIX;
        this.depth = newDepth;
        return this.newEntry(String.format(ENTRY_MESSAGE, prefix, SmallCapsConverter.convert(key), value));
    }

    public StructuredMessageBuilder rawEntryDown(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        int newDepth = this.depth + 1;
        String prefix = " " + "  ".repeat(this.depth) + ENDING_ENTRY_PREFIX;
        this.depth = newDepth;
        return this.newEntry(prefix + " " + message);
    }

    public StructuredMessageBuilder entry(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String prefix = " " + "  ".repeat(Math.max(0, this.depth)) + ENTRY_PREFIX;
        return this.newEntry(String.format(ENTRY_MESSAGE, prefix, SmallCapsConverter.convert(key), value));
    }

    public StructuredMessageBuilder finalEntry(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String prefix = " " + "  ".repeat(Math.max(0, this.depth)) + ENDING_ENTRY_PREFIX;
        return this.newEntry(String.format(ENTRY_MESSAGE, prefix, SmallCapsConverter.convert(key), value));
    }

    private StructuredMessageBuilder newEntry(@NonNull String message) {
        List page;
        List lastPage;
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.pages.isEmpty()) {
            this.pages.put(0, new ArrayList());
        }
        if ((lastPage = this.pages.get(this.pages.size() - 1)) == null) {
            return this;
        }
        List list = page = lastPage.size() < 10 ? lastPage : (List)this.pages.put(this.pages.size(), new ArrayList());
        if (page == null) {
            return this;
        }
        page.add((String)Formatter.format(message, new StringModifier[0]));
        return this;
    }

    public StructuredMessage build() {
        return new StructuredMessage(this.header, this.pages);
    }
}

