/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.reference;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.reference.ReferenceResolver;
import org.jetbrains.annotations.Nullable;

public class ObjectReference<K, O> {
    @NonNull
    private final K id;
    @NonNull
    private final ReferenceResolver<K, O> resolver;
    @Nullable
    private volatile O cachedObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<O> get() {
        Object resolved = this.resolver.resolve(this.id).orElse(null);
        if (resolved == null) {
            return Optional.empty();
        }
        O localCache = this.cachedObject;
        if (localCache == null || localCache != resolved) {
            ObjectReference objectReference = this;
            synchronized (objectReference) {
                if (this.cachedObject == null || this.cachedObject != resolved) {
                    this.cachedObject = resolved;
                }
            }
        }
        return Optional.of(resolved);
    }

    public boolean isCached() {
        return this.cachedObject != null;
    }

    public boolean forceValidate() {
        return this.resolver.resolve(this.id).isPresent();
    }

    public synchronized void invalidateCache() {
        this.cachedObject = null;
    }

    public Optional<O> refresh() {
        Optional<O> resolved = this.resolver.resolve(this.id);
        resolved.ifPresent(o -> {
            ObjectReference objectReference = this;
            synchronized (objectReference) {
                this.cachedObject = o;
            }
        });
        return resolved;
    }

    @Generated
    public ObjectReference(@NonNull K id, @NonNull ReferenceResolver<K, O> resolver) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.id = id;
        this.resolver = resolver;
    }

    @NonNull
    @Generated
    public K getId() {
        return this.id;
    }
}

