/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.sound;

import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SoundData {
    private final Sound sound;
    private final float volume;
    private final float pitch;

    public void play(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        player.playSound((Entity)player, this.sound, this.volume, this.pitch);
    }

    public void play(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        location.getWorld().playSound(location, this.sound, this.volume, this.pitch);
    }

    public static SoundData fromString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        String[] data = string.split(":");
        if (data.length != 3) {
            throw new IllegalArgumentException("Invalid SoundData string");
        }
        return new SoundData(Sound.valueOf((String)data[0].toUpperCase()), Float.parseFloat(data[1]), Float.parseFloat(data[2]));
    }

    public String toString() {
        return String.format("%s:%s:%s", this.sound.name(), Float.valueOf(this.volume), Float.valueOf(this.pitch));
    }

    @Generated
    public Sound getSound() {
        return this.sound;
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public SoundData(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }
}

