/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.trigger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.TriggerProvider;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl.event.PlayerChatTrigger;

public final class TriggerRegistry {
    private static final Map<String, TriggerProvider> PROVIDERS = new HashMap<String, TriggerProvider>();
    private static final Map<String, List<Consumer<TriggerProvider>>> PENDING_TRIGGERS = new ConcurrentHashMap<String, List<Consumer<TriggerProvider>>>();

    private TriggerRegistry() {
    }

    public static void register(@NonNull String id, @NonNull TriggerProvider provider) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (PROVIDERS.containsKey(id.toLowerCase())) {
            throw new IllegalArgumentException("Trigger with ID '" + id + "' already registered");
        }
        PROVIDERS.putIfAbsent(id.toLowerCase(), provider);
        List<Consumer<TriggerProvider>> consumers = PENDING_TRIGGERS.remove(id);
        if (consumers == null) {
            return;
        }
        consumers.forEach(c -> c.accept(provider));
    }

    public static void unregister(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        PROVIDERS.remove(id.toLowerCase());
    }

    public static Optional<TriggerProvider> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return Optional.ofNullable(PROVIDERS.get(id.toLowerCase()));
    }

    public static Set<String> getIds() {
        return PROVIDERS.keySet();
    }

    public static boolean contains(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return PROVIDERS.containsKey(id.toLowerCase());
    }

    public static void clear() {
        PROVIDERS.clear();
    }

    public static void whenAvailable(String id, Consumer<TriggerProvider> consumer) {
        TriggerProvider existingProvider = PROVIDERS.get(id);
        if (existingProvider != null) {
            consumer.accept(existingProvider);
            return;
        }
        PENDING_TRIGGERS.computeIfAbsent(id, k -> new CopyOnWriteArrayList()).add(consumer);
    }

    static {
        TriggerRegistry.register("player_chat", PlayerChatTrigger::new);
    }
}

