/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl;

import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.packetblocks.lib.bitsutils.context.Context;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl.SimpleTrigger;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public abstract class EventTrigger<T extends Event>
extends SimpleTrigger
implements Listener {
    @Nullable
    private JavaPlugin plugin;

    public EventTrigger(@NonNull String id, @NonNull ConfiguredMetadata metadata) {
        super(id, metadata);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
    }

    public void setActive(boolean active, @NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.setActive(active);
        if (this.plugin == null) {
            this.plugin = plugin;
        }
        if (!active) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void onDeactivate(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        HandlerList.unregisterAll((Listener)this);
    }

    public abstract void onEvent(T var1);

    @Nullable
    @Generated
    protected JavaPlugin getPlugin() {
        return this.plugin;
    }
}

