/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.packetblocks.lib.bitsutils.context.Context;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.Trigger;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.TriggerAction;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleTrigger
implements Trigger {
    private final List<Trigger> children = new ArrayList<Trigger>();
    @NonNull
    private final String id;
    private boolean repeatable;
    private boolean deactivateChildren;
    private boolean active;
    private TriggerAction action;

    protected SimpleTrigger(@NonNull String id, @NonNull ConfiguredMetadata metadata) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.id = id;
        this.repeatable = metadata.getDeepValueAsOrDefault("Repeatable", false);
        this.deactivateChildren = metadata.getDeepValueAsOrDefault("Deactivate-Children", false);
    }

    @Override
    public void trigger(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (!this.active) {
            return;
        }
        if (this.action != null) {
            this.action.onTrigger(context);
        }
        if (this.repeatable) {
            return;
        }
        this.active = false;
        this.onDeactivate(context);
        if (!this.deactivateChildren) {
            return;
        }
        this.children.forEach(trigger -> {
            trigger.setActive(false);
            trigger.onDeactivate(context);
        });
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    @Override
    public boolean isDeactivateChildren() {
        return this.deactivateChildren;
    }

    @Override
    @NotNull
    public List<Trigger> getChildren() {
        return this.children;
    }

    @Override
    public void setAction(@NonNull TriggerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.action = action;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimpleTrigger that = (SimpleTrigger)object;
        return this.repeatable == that.repeatable && this.deactivateChildren == that.deactivateChildren && this.active == that.active && Objects.equals(this.children, that.children) && Objects.equals(this.id, that.id) && Objects.equals(this.action, that.action);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.id, this.repeatable, this.deactivateChildren, this.active, this.action);
    }

    @Override
    @NotNull
    public Trigger clone() {
        try {
            Trigger cloned = (Trigger)super.clone();
            if (this.action != null) {
                cloned.setAction(this.action);
            }
            cloned.getChildren().clear();
            for (Trigger child : this.children) {
                cloned.getChildren().add(child.clone());
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Trigger should be cloneable", e);
        }
    }

    @Override
    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public TriggerAction getAction() {
        return this.action;
    }

    @Generated
    protected void setDeactivateChildren(boolean deactivateChildren) {
        this.deactivateChildren = deactivateChildren;
    }
}

