/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl.event;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.bitbylogic.packetblocks.lib.bitsutils.config.metadata.ConfiguredMetadata;
import net.bitbylogic.packetblocks.lib.bitsutils.context.ContextBuilder;
import net.bitbylogic.packetblocks.lib.bitsutils.trigger.impl.EventTrigger;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerChatTrigger
extends EventTrigger<AsyncPlayerChatEvent> {
    private final Cache<UUID, Integer> messageCountCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final String mustContain;
    private final int messageCount;

    public PlayerChatTrigger(@NonNull ConfiguredMetadata metadata) {
        super("player_chat", metadata);
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.mustContain = metadata.getDeepValueAsOrDefault("Must-Contain", null);
        this.messageCount = metadata.getValueAsOrDefault("Message-Count", 0);
    }

    @Override
    @EventHandler(priority=EventPriority.LOWEST)
    public void onEvent(AsyncPlayerChatEvent event) {
        if (this.mustContain != null && !event.getMessage().contains(this.mustContain)) {
            return;
        }
        if (this.messageCount <= 0) {
            Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> this.trigger(ContextBuilder.create().with(event.getPlayer()).build()));
            return;
        }
        UUID playerId = event.getPlayer().getUniqueId();
        Integer messagesCached = (Integer)this.messageCountCache.getIfPresent((Object)playerId);
        int messages = messagesCached != null ? messagesCached : 0;
        this.messageCountCache.put((Object)playerId, (Object)(++messages));
        if (messages >= this.messageCount) {
            Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> this.trigger(ContextBuilder.create().with(event.getPlayer()).build()));
            this.messageCountCache.invalidate((Object)playerId);
        }
    }
}

