/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.task;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.potion.PotionTypes;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockBreakAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRemoveEntityEffect;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.bitbylogic.packetblocks.block.PacketBlock;
import net.bitbylogic.packetblocks.task.BlockAnimationContext;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketBlockAnimationTask
extends BukkitRunnable {
    private final Map<Player, BlockAnimationContext> blockMap = new HashMap<Player, BlockAnimationContext>();

    public void run() {
        for (Map.Entry<Player, BlockAnimationContext> entry : this.blockMap.entrySet()) {
            Player player = entry.getKey();
            BlockAnimationContext context = entry.getValue();
            PacketBlock packetBlock = context.getBlock();
            int breakSpeed = packetBlock.getBreakSpeed(player);
            int ticksTaken = context.getTicksTaken();
            context.setTicksTaken(ticksTaken + 1);
            float progress = (float)context.getTicksTaken() / (float)breakSpeed;
            if (breakSpeed <= 0 || progress >= 1.0f) {
                this.sendFinishBreak(player, packetBlock);
                continue;
            }
            int stage = (int)(progress * 10.0f);
            if (stage == context.getStage()) continue;
            if (packetBlock.isGlobalBreakAnimation()) {
                this.sendAnimationToAllViewers(packetBlock, stage);
            } else {
                this.sendAnimation(player, packetBlock, stage);
            }
            context.setStage(stage);
        }
    }

    public void addEntry(Player player, PacketBlock block) {
        WrapperPlayServerEntityEffect effectPacket = new WrapperPlayServerEntityEffect(player.getEntityId(), PotionTypes.MINING_FATIGUE, 127, Integer.MAX_VALUE, 1);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)effectPacket);
        this.blockMap.put(player, new BlockAnimationContext(block));
    }

    public void removeEntry(Player player) {
        BlockAnimationContext context = this.blockMap.remove(player);
        if (context == null) {
            return;
        }
        PacketBlock block = context.getBlock();
        this.sendFinishBreak(player, block);
        WrapperPlayServerRemoveEntityEffect removeEffect = new WrapperPlayServerRemoveEntityEffect(player.getEntityId(), PotionTypes.MINING_FATIGUE);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)removeEffect);
    }

    private void sendAnimation(Player player, PacketBlock block, int stage) {
        Location blockLocation = block.getLocation();
        Vector3i position = new Vector3i(blockLocation.getBlockX(), blockLocation.getBlockY(), blockLocation.getBlockZ());
        WrapperPlayServerBlockBreakAnimation animation = new WrapperPlayServerBlockBreakAnimation(player.getEntityId(), position, (byte)stage);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)animation);
    }

    private void sendAnimationToAllViewers(PacketBlock block, int stage) {
        Iterator<UUID> it = block.getViewers().keySet().iterator();
        while (it.hasNext()) {
            Player viewer = Bukkit.getPlayer((UUID)it.next());
            if (viewer == null) {
                it.remove();
                continue;
            }
            this.sendAnimation(viewer, block, stage);
        }
    }

    private void sendFinishBreak(Player player, PacketBlock block) {
        this.sendAnimation(player, block, -1);
        if (block.isGlobalBreakAnimation()) {
            Iterator<UUID> it = block.getViewers().keySet().iterator();
            while (it.hasNext()) {
                Player viewer = Bukkit.getPlayer((UUID)it.next());
                if (viewer == null) {
                    it.remove();
                    continue;
                }
                this.sendAnimation(viewer, block, -1);
            }
        }
    }
}

