/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.packetblocks.util;

import lombok.NonNull;
import net.bitbylogic.packetblocks.PacketBlocks;
import net.bitbylogic.packetblocks.block.PacketBlockManager;
import net.bitbylogic.packetblocks.util.BoundingBoxes;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class PacketBlockUtil {
    public static Material getBlockType(@NonNull Player player, @NonNull Location location) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (location.getWorld() == null) {
            return Material.AIR;
        }
        return PacketBlocks.getInstance().getBlockManager().getBlock(location).map(packetBlock -> packetBlock.getBlockState(player).getBlockData().getMaterial()).orElse(location.getBlock().getType());
    }

    public static RayTraceResult rayTrace(Player player, double range) {
        PacketBlockManager PacketBlockManager2 = PacketBlocks.getInstance().getBlockManager();
        Location eye = player.getEyeLocation();
        Vector direction = eye.getDirection().normalize();
        World world = player.getWorld();
        RayTraceResult vanillaResult = world.rayTraceBlocks(eye, direction, range, FluidCollisionMode.NEVER, false);
        Vector current = eye.toVector();
        double step = 0.05;
        for (double traveled = 0.0; traveled <= range; traveled += step) {
            RayTraceResult boxResult;
            Material blockMaterial;
            BoundingBox boundingBox;
            current.add(direction.clone().multiply(step));
            Block block = world.getBlockAt(current.getBlockX(), current.getBlockY(), current.getBlockZ());
            if (!PacketBlockManager2.getBlock(block.getLocation()).isPresent() || (boundingBox = BoundingBoxes.getBoxAt(blockMaterial = PacketBlockManager2.getBlock(block.getLocation()).get().getBlockData().getMaterial(), block.getLocation())) == null || (boxResult = boundingBox.rayTrace(eye.toVector(), direction, range)) == null) continue;
            return new RayTraceResult(boxResult.getHitPosition(), block, boxResult.getHitBlockFace());
        }
        return vanillaResult;
    }
}

