/*
 * Decompiled with CFR 0.152.
 */
package net.blzinite.horsectrl.entity;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ControlledHorseEntity
extends Horse {
    private static final EntityDataAccessor<Float> HEAD_ROTATION = SynchedEntityData.m_135353_(ControlledHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BODY_ROTATION = SynchedEntityData.m_135353_(ControlledHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(ControlledHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> MAX_SPURS = SynchedEntityData.m_135353_(ControlledHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPURS = SynchedEntityData.m_135353_(ControlledHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean allowSpur = false;
    private static final Style SPUR_FONT = Style.f_131099_.m_131150_(ResourceLocation.fromNamespaceAndPath((String)"horse_ctrl", (String)"spurs"));

    public ControlledHorseEntity(EntityType<? extends Horse> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD_ROTATION, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(BODY_ROTATION, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_SPURS, (Object)2);
        this.f_19804_.m_135372_(SPURS, (Object)Float.valueOf(2.0f));
    }

    public void m_30665_(boolean shouldStand) {
        super.m_30665_(shouldStand);
        if (shouldStand) {
            List kickedEntites = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20182_(), this.m_20182_()).m_82400_(2.0), e -> !this.m_20197_().contains(e));
            for (LivingEntity livingEntity : kickedEntites) {
                if (livingEntity.equals((Object)this)) continue;
                livingEntity.m_147240_((double)2.4f, (double)Mth.m_14031_((float)((float)((double)this.m_146908_() * (Math.PI / 180)))), (double)(-Mth.m_14089_((float)((float)((double)this.m_146908_() * (Math.PI / 180))))));
                float dmg = (float)this.m_21133_(Attributes.f_22276_) * (float)this.m_21133_(Attributes.f_22279_) * 2.0f;
                livingEntity.m_6469_(livingEntity.m_269291_().m_269333_((LivingEntity)this), dmg);
            }
        }
    }

    public float getHeadRotation() {
        return ((Float)this.f_19804_.m_135370_(HEAD_ROTATION)).floatValue();
    }

    public void setHeadRotation(float headRotation) {
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf(headRotation));
    }

    public float getBodyRotation() {
        return ((Float)this.f_19804_.m_135370_(BODY_ROTATION)).floatValue();
    }

    public void setBodyRotation(float bodyRotation) {
        this.f_19804_.m_135381_(BODY_ROTATION, (Object)Float.valueOf(bodyRotation));
    }

    public float getCruiseSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public void setCruiseSpeed(float cruiseSpeed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(cruiseSpeed));
    }

    public int getMaxSpurs() {
        return (Integer)this.f_19804_.m_135370_(MAX_SPURS);
    }

    public void setMaxSpurs(int value) {
        this.f_19804_.m_135381_(MAX_SPURS, (Object)value);
    }

    public float getSpurs() {
        return ((Float)this.f_19804_.m_135370_(SPURS)).floatValue();
    }

    public void setSpurs(float value) {
        this.f_19804_.m_135381_(SPURS, (Object)Float.valueOf(value));
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setMaxSpurs(tag.m_128451_("MaxSpurs"));
        this.setSpurs(this.getMaxSpurs());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("MaxSpurs", this.getMaxSpurs());
    }

    protected void m_274498_(@NotNull Player player, @NotNull Vec3 travelVector) {
        float speed = this.getCruiseSpeed();
        float rate = Mth.m_14207_((float)(5.0f - speed)) / 4.0f;
        this.setBodyRotation(Mth.m_14148_((float)this.getBodyRotation(), (float)this.getHeadRotation(), (float)rate));
        float headHeight = 0.0f;
        if (speed > 3.0f) {
            this.setCruiseSpeed(speed - 0.006f);
            this.spawnSprintParticles();
            headHeight = 15.0f;
        }
        this.m_19915_(this.getBodyRotation(), headHeight);
        this.f_20885_ = this.getHeadRotation();
        this.f_19859_ = this.f_20883_ = this.m_146908_();
        if (this.getSpurs() < (float)this.getMaxSpurs()) {
            this.setSpurs(this.getSpurs() + 0.004f);
        }
        if (this.m_6109_()) {
            if (travelVector.f_82481_ <= 0.0) {
                this.f_30524_ = 0;
            }
            if (this.m_20096_()) {
                this.m_30655_(false);
                if (this.f_30522_ > 0.0f && !this.m_30616_()) {
                    this.m_245980_(this.f_30522_, travelVector);
                }
                this.f_30522_ = 0.0f;
            }
        }
    }

    private void spawnSprintParticles() {
        if (this.f_19796_.m_188501_() < 0.3f) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double y = this.m_20186_() + 0.1;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    protected float m_245547_(@NotNull Player player) {
        int speed = Mth.m_14167_((float)this.getCruiseSpeed());
        if (!this.allowSpur && speed >= 3 && (double)player.f_20902_ < 0.5) {
            this.allowSpur = true;
        }
        return switch (speed) {
            case 1 -> (float)(0.2 * this.m_21133_(Attributes.f_22279_));
            case 2 -> (float)(0.5 * this.m_21133_(Attributes.f_22279_));
            case 4 -> (float)(1.5 * this.m_21133_(Attributes.f_22279_));
            default -> (float)this.m_21133_(Attributes.f_22279_);
        };
    }

    protected void m_6835_(@NotNull Player player) {
        super.m_6835_(player);
        this.setHeadRotation(this.m_6080_());
        this.setBodyRotation(this.getBodyRotation());
        this.setCruiseSpeed(0.0f);
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player rider, @NotNull Vec3 travelVector) {
        if (this.m_20096_() && this.f_30522_ == 0.0f && this.m_30622_() && !this.f_30510_) {
            return Vec3.f_82478_;
        }
        float speed = this.getCruiseSpeed();
        float z_input = rider.f_20902_;
        if (z_input > 0.0f) {
            z_input *= 0.25f;
        }
        float spurs = this.getSpurs();
        if (z_input < 0.0f) {
            if (speed > 2.0f) {
                this.allowSpur = false;
                this.m_7564_();
            }
            speed = Mth.m_14036_((float)(speed + z_input), (float)0.0f, (float)3.0f);
        } else if (Mth.m_14167_((float)speed) >= 3) {
            if (this.m_9236_().f_46443_) {
                String spursDisplay = "\ue000".repeat(Math.max(0, Mth.m_14143_((float)spurs))) + "\ue001".repeat(Math.max(0, this.getMaxSpurs() - Mth.m_14143_((float)spurs)));
                rider.m_5661_((Component)Component.m_237113_((String)spursDisplay).m_130948_(SPUR_FONT), true);
            }
            if (this.allowSpur && (double)z_input > 0.2 && spurs >= 1.0f) {
                speed = 4.0f;
                this.allowSpur = false;
                rider.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12276_, SoundSource.PLAYERS, 1.0f, 0.2f);
                rider.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11971_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setSpurs(spurs - 1.0f);
            }
        } else {
            speed = z_input == 0.0f ? (float)Mth.m_14167_((float)speed) : Mth.m_14036_((float)(speed + z_input), (float)0.0f, (float)3.0f);
        }
        this.setCruiseSpeed(speed);
        float x_input = this.getHeadRotation() - 4.0f * rider.f_20900_;
        if (Mth.m_14145_((float)x_input, (float)this.getBodyRotation()) < 30.0f) {
            this.setHeadRotation(x_input);
        }
        if (this.getCruiseSpeed() <= 0.0f && rider.f_20902_ <= 0.0f) {
            return new Vec3(0.0, 0.0, (double)rider.f_20902_ * 0.25);
        }
        return new Vec3(0.0, 0.0, (double)this.getCruiseSpeed());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.setMaxSpurs(this.f_19796_.m_216332_(2, 5));
        this.setSpurs(this.getMaxSpurs());
    }
}

