/*
 * Decompiled with CFR 0.152.
 */
package net.blzinite.horsectrl.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ControlledHorseRenderer
extends AbstractHorseRenderer<Horse, HorseModel<Horse>> {
    private static final Map<Variant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(Variant.class), v -> {
        v.put(Variant.WHITE, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_white.png"));
        v.put(Variant.CREAMY, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_creamy.png"));
        v.put(Variant.CHESTNUT, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_chestnut.png"));
        v.put(Variant.BROWN, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_brown.png"));
        v.put(Variant.BLACK, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_black.png"));
        v.put(Variant.GRAY, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_gray.png"));
        v.put(Variant.DARK_BROWN, ResourceLocation.parse((String)"minecraft:textures/entity/horse/horse_darkbrown.png"));
    });
    private float lean = 0.0f;

    public ControlledHorseRenderer(EntityRendererProvider.Context context) {
        super(context, new HorseModel(context.m_174023_(ModelLayers.f_171186_)), 1.1f);
        this.m_115326_((RenderLayer)new HorseMarkingLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new HorseArmorLayer((RenderLayerParent)this, context.m_174027_()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(Horse horse) {
        return LOCATION_BY_VARIANT.get(horse.m_28554_());
    }

    protected void setupRotations(@NotNull Horse horse, @NotNull PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)horse, poseStack, ageInTicks, rotationYaw, partialTicks);
        LivingEntity livingEntity = horse.m_6688_();
        if (livingEntity instanceof Player) {
            Player rider = (Player)livingEntity;
            if ((double)rider.f_20902_ >= 0.0 && horse.m_20184_().m_165925_() > 0.0) {
                float yawDiff = horse.m_146908_() - horse.f_20885_;
                float leanAngle = Mth.m_14036_((float)(yawDiff * 2.0f), (float)-5.0f, (float)5.0f);
                this.lean += (leanAngle - this.lean) * 0.2f;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(this.lean));
            }
        }
    }
}

