/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wtf.hak.survivalfabric.commands.ReloadConfigCommand;
import wtf.hak.survivalfabric.commands.SlimeChunkCommand;
import wtf.hak.survivalfabric.commands.SpectatorCommand;
import wtf.hak.survivalfabric.config.ConfigManager;
import wtf.hak.survivalfabric.features.sharedenderchest.SharedEnderChest;
import wtf.hak.survivalfabric.features.veinminer.VeinMinerEvents;
import wtf.hak.survivalfabric.utils.Scheduler;

public class SurvivalFabric
implements ModInitializer {
    public static final String MOD_ID = "survivalfabric";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"survivalfabric");

    public void onInitialize() {
        Scheduler.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SpectatorCommand.register((CommandDispatcher<class_2168>)dispatcher, "spectator", "s", "S", "camera", "c", "C"));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ReloadConfigCommand.register((CommandDispatcher<class_2168>)dispatcher, "reloadsurvivalconfig"));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SlimeChunkCommand.register((CommandDispatcher<class_2168>)dispatcher, "slimechunk", "sc"));
        if (ConfigManager.getConfig().sharedEnderChestEnabled) {
            new SharedEnderChest().onInitialize();
        }
        if (ConfigManager.getConfig().veinMinerEnabled) {
            PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (ConfigManager.getConfig().veinMinerEnabled) {
                        return VeinMinerEvents.beforeBlockBreak(world, serverPlayer, pos, state);
                    }
                }
                return true;
            });
            ServerEntityEvents.ENTITY_LOAD.register(VeinMinerEvents::onEntityLoad);
        }
    }
}

