/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import wtf.hak.survivalfabric.config.Config;

public class ConfigManager {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("survivalfabric.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Config INSTANCE;

    public static Config getConfig() {
        if (INSTANCE == null) {
            return ConfigManager.load();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Config load() {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (ConfigManager.INSTANCE.configVersion.equalsIgnoreCase(new Config().configVersion)) {
                Config config = INSTANCE;
                return config;
            }
            ConfigManager.INSTANCE.configVersion = new Config().configVersion;
            ConfigManager.save(INSTANCE);
            Config config = INSTANCE;
            return config;
        }
        catch (IOException e) {
            Config config2;
            INSTANCE = config2 = new Config();
            ConfigManager.save(config2);
            return config2;
        }
    }

    public static void save(Config config) {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            System.out.println("Error saving config: " + e.getMessage());
        }
    }
}

