/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.features.veinminer.drills;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import wtf.hak.survivalfabric.SurvivalFabric;
import wtf.hak.survivalfabric.config.ConfigManager;
import wtf.hak.survivalfabric.features.veinminer.Drill;
import wtf.hak.survivalfabric.features.veinminer.VeinMinerSession;
import wtf.hak.survivalfabric.utils.Scheduler;

public class DrillBase
implements Drill {
    protected VeinMinerSession session;
    protected class_6862<class_2248> tag;

    public DrillBase(VeinMinerSession session, class_6862<class_2248> tag) {
        this.session = session;
        this.tag = tag;
    }

    @Override
    public boolean canHandle(class_2680 blockState) {
        return blockState.method_26164(this.tag);
    }

    @Override
    public boolean drill(class_2338 startPos) {
        this.handleBlock(this.session.world.method_8320(startPos).method_26204(), new HashSet<class_2338>(), startPos, 0);
        return true;
    }

    private void handleBlock(class_2248 initialBlock, Set<class_2338> history, class_2338 pos, int brokenBlocks) {
        if (brokenBlocks < ConfigManager.getConfig().maxVeinSize) {
            history.add(pos);
            if (this.tryBreakBlock(pos)) {
                int finalBrokenBlocks = ++brokenBlocks;
                HashSet<class_2338> toBreak = new HashSet<class_2338>();
                this.collectAdjacentBlocks(pos, history, initialBlock, toBreak);
                long delay = ConfigManager.getConfig().veinAnimationTicks;
                int[] finalBrokenBlocksArr = new int[]{finalBrokenBlocks};
                if (delay <= 0L) {
                    this.handleBlocksInBatch(toBreak, initialBlock, history, finalBrokenBlocksArr[0]);
                } else {
                    Scheduler.get().scheduleTask(() -> this.handleBlocksInBatch(toBreak, initialBlock, history, finalBrokenBlocksArr[0]), delay);
                }
            }
        }
    }

    private void collectAdjacentBlocks(class_2338 pos, final Set<class_2338> history, final class_2248 initialBlock, final Set<class_2338> toBreak) {
        this.forXYZ(pos, 1, new ForXYZHandler(){

            @Override
            public void handle(class_2338 newPos) {
                if (!history.contains(newPos) && DrillBase.this.session.world.method_8320(newPos).method_26204() == initialBlock) {
                    toBreak.add(newPos);
                }
            }
        });
    }

    private void handleBlocksInBatch(Set<class_2338> toBreak, class_2248 initialBlock, Set<class_2338> history, int finalBrokenBlocks) {
        for (class_2338 newPos : toBreak) {
            this.handleBlock(initialBlock, history, newPos, finalBrokenBlocks);
        }
    }

    @Override
    public boolean isRightTool(class_2338 pos) {
        class_2680 blockState = this.session.world.method_8320(pos);
        return this.session.player.method_6047().method_7951(blockState);
    }

    protected void forXYZ(class_2338 pos, int max, final ForXYZHandler handler) {
        this.forXYZ(pos, max, new ForXYZCounter(){

            @Override
            public int handle(class_2338 pos) {
                handler.handle(pos);
                return 1;
            }
        }, false);
    }

    protected int forXYZ(class_2338 pos, int max, ForXYZCounter handler) {
        return this.forXYZ(pos, max, handler, false);
    }

    protected void forXYZ(class_2338 pos, int max, final ForXYZHandler handler, boolean forceVertical) {
        this.forXYZ(pos, max, new ForXYZCounter(){

            @Override
            public int handle(class_2338 pos) {
                handler.handle(pos);
                return 1;
            }
        }, forceVertical);
    }

    protected int forXYZ(class_2338 pos, int max, ForXYZCounter handler, boolean forceVertical) {
        HashSet<Integer> offsets = new HashSet<Integer>();
        for (int d = 0; d <= max; ++d) {
            offsets.add(d);
            if (d == -d) continue;
            offsets.add(-d);
        }
        String[] order = this.determineOrder(forceVertical);
        int counter = 0;
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int i1 = (Integer)iterator.next();
            Iterator iterator2 = offsets.iterator();
            while (iterator2.hasNext()) {
                int i2 = (Integer)iterator2.next();
                Iterator iterator3 = offsets.iterator();
                while (iterator3.hasNext()) {
                    int iy;
                    int ix;
                    int i3 = (Integer)iterator3.next();
                    int n = order[0].equals("x") ? i1 : (ix = order[1].equals("x") ? i2 : i3);
                    int n2 = order[0].equals("y") ? i1 : (iy = order[1].equals("y") ? i2 : i3);
                    int iz = order[0].equals("z") ? i1 : (order[1].equals("z") ? i2 : i3);
                    int px = pos.method_10263() + ix;
                    int py = pos.method_10264() + iy;
                    int pz = pos.method_10260() + iz;
                    counter += handler.handle(new class_2338(px, py, pz));
                }
            }
        }
        return counter;
    }

    protected String[] determineOrder(boolean forceVertical) {
        boolean majorYawChange;
        if (forceVertical) {
            return new String[]{"y", "x", "z"};
        }
        class_3222 player = this.session.player;
        boolean majorPitchChange = (double)player.method_36455() < -45.0 || (double)player.method_36455() > 45.0;
        boolean bl = majorYawChange = (double)player.method_36454() > 45.0 && (double)player.method_36454() < 135.0 || (double)player.method_36454() < -45.0 && (double)player.method_36454() > -135.0;
        if (majorPitchChange) {
            if (majorYawChange) {
                return new String[]{"y", "z", "x"};
            }
            return new String[]{"y", "x", "z"};
        }
        if (majorYawChange) {
            return new String[]{"z", "y", "x"};
        }
        return new String[]{"x", "y", "z"};
    }

    protected boolean tryBreakBlock(class_2338 blockPos) {
        boolean success;
        this.session.addPosition(blockPos);
        boolean bl = success = this.isRightTool(blockPos) && this.session.player.field_13974.method_14266(blockPos);
        if (!success) {
            this.session.removePosition(blockPos);
        }
        return success;
    }

    protected void _log(String message) {
        class_8828.class_2585 literal = new class_8828.class_2585(message);
        class_5250 text = class_5250.method_43477((class_7417)literal);
        this.session.player.method_64398((class_2561)text);
        SurvivalFabric.LOGGER.info(message);
    }

    protected static interface ForXYZHandler {
        public void handle(class_2338 var1);
    }

    protected static interface ForXYZCounter {
        public int handle(class_2338 var1);
    }
}

