/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.utils;

public class MathUtils {
    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static boolean hasSupportedOperator(String msg) {
        return msg.contains("+") || msg.contains("-") || msg.contains("*") || msg.contains("/");
    }

    public static double evaluateExpression(String expression) {
        return MathUtils.evaluate(expression.replaceAll("\\s", ""), new int[]{0});
    }

    public static double evaluate(String expr, int[] index) {
        char op;
        double value = MathUtils.parseTerm(expr, index);
        while (index[0] < expr.length() && ((op = expr.charAt(index[0])) == '+' || op == '-')) {
            index[0] = index[0] + 1;
            double nextTerm = MathUtils.parseTerm(expr, index);
            value = op == '+' ? value + nextTerm : value - nextTerm;
        }
        return value;
    }

    public static double parseTerm(String expr, int[] index) {
        char op;
        double value = MathUtils.parseFactor(expr, index);
        while (index[0] < expr.length() && ((op = expr.charAt(index[0])) == '*' || op == '/')) {
            index[0] = index[0] + 1;
            double nextFactor = MathUtils.parseFactor(expr, index);
            value = op == '*' ? value * nextFactor : value / nextFactor;
        }
        return value;
    }

    public static double parseFactor(String expr, int[] index) {
        if (expr.charAt(index[0]) == '(') {
            index[0] = index[0] + 1;
            double value = MathUtils.evaluate(expr, index);
            index[0] = index[0] + 1;
            return value;
        }
        int start = index[0];
        while (index[0] < expr.length() && (Character.isDigit(expr.charAt(index[0])) || expr.charAt(index[0]) == '.')) {
            index[0] = index[0] + 1;
        }
        return Double.parseDouble(expr.substring(start, index[0]));
    }
}

