/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class Scheduler {
    private static Scheduler INSTANCE;
    private final Map<Runnable, Long> tasks = new ConcurrentHashMap<Runnable, Long>();

    public Scheduler() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (Runnable task : this.tasks.keySet()) {
                long delay = this.tasks.get(task);
                if (delay <= 0L) {
                    task.run();
                    this.tasks.remove(task);
                    continue;
                }
                this.tasks.put(task, delay - 1L);
            }
        });
    }

    public void scheduleTask(Runnable task) {
        this.scheduleTask(task, 0L);
    }

    public void scheduleTask(Runnable task, long delay) {
        this.tasks.put(task, delay);
    }

    public static Scheduler get() {
        return INSTANCE;
    }

    public static Scheduler initialize() {
        INSTANCE = new Scheduler();
        return INSTANCE;
    }
}

