/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.config.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import wtf.hak.survivalfabric.config.Config;
import wtf.hak.survivalfabric.config.client.ClientConfig;

@Environment(value=EnvType.CLIENT)
public class ClientConfigManager {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("survivalfabric-client.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ClientConfig INSTANCE;

    public static ClientConfig getConfig() {
        if (INSTANCE == null) {
            return ClientConfigManager.load();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientConfig load() {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            INSTANCE = (ClientConfig)GSON.fromJson((Reader)reader, ClientConfig.class);
            if (ClientConfigManager.INSTANCE.configVersion.equalsIgnoreCase(new Config().configVersion)) {
                ClientConfig clientConfig = INSTANCE;
                return clientConfig;
            }
            ClientConfigManager.INSTANCE.configVersion = new ClientConfig().configVersion;
            ClientConfigManager.save(INSTANCE);
            ClientConfig clientConfig = INSTANCE;
            return clientConfig;
        }
        catch (IOException e) {
            ClientConfig config;
            INSTANCE = config = new ClientConfig();
            ClientConfigManager.save(config);
            return config;
        }
    }

    public static void save() {
        ClientConfigManager.save(INSTANCE);
    }

    public static void save(ClientConfig config) {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            System.out.println("Error saving config: " + e.getMessage());
        }
    }
}

