/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.features.sharedenderchest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import wtf.hak.survivalfabric.SurvivalFabric;
import wtf.hak.survivalfabric.config.ConfigManager;
import wtf.hak.survivalfabric.features.sharedenderchest.SharedInventory;

public class SharedEnderChest
implements ServerLifecycleEvents.ServerStopping,
ServerLifecycleEvents.ServerStarted,
ServerTickEvents.EndTick {
    private static SharedInventory sharedInventory;
    private long ticksUntilSave = -20L;

    public static void saveInventory(MinecraftServer server) {
        File inventoryFile = SharedEnderChest.getFile(server);
        class_2487 nbt = new class_2487();
        class_2371 inventoryItemStacks = class_2371.method_10213((int)(ConfigManager.getConfig().sharedEnderChestRows * 9), (Object)class_1799.field_8037);
        class_1262.method_5426((class_2487)nbt, sharedInventory.getList((class_2371<class_1799>)inventoryItemStacks), (class_7225.class_7874)server.method_30611());
        try (FileOutputStream inventoryFileOutputStream = new FileOutputStream(inventoryFile);
             DataOutputStream inventoryFileDataOutput = new DataOutputStream(inventoryFileOutputStream);){
            inventoryFile.createNewFile();
            class_2507.method_10634((class_2487)nbt, (OutputStream)inventoryFileDataOutput);
        }
        catch (Exception e) {
            SurvivalFabric.LOGGER.error("Error while saving Shared Ender Chest: " + String.valueOf(e));
        }
    }

    public static void openSharedEnderChest(class_1657 player, class_1937 world, class_2338 pos) {
        SharedEnderChest.fakeEnderChestOpen(world, pos, true);
        SharedEnderChest.sharedInventory.openedEnderChests.put(player, pos);
        player.method_17355((class_3908)new class_747((int_1, playerInventory, playerEntity) -> new class_1707(ConfigManager.getConfig().screenHandlerType(), int_1, playerInventory, (class_1263)sharedInventory, ConfigManager.getConfig().sharedEnderChestRows), class_2561.method_30163((String)ConfigManager.getConfig().sharedEnderChestName)));
    }

    public static void playEnderChestOpenSound(class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, class_3417.field_14952, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public static void playEnderChestCloseSound(class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, class_3417.field_15206, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public static void fakeEnderChestOpen(class_1937 world, class_2338 pos, boolean open) {
        if (!(world.method_8320(pos).method_26204() instanceof class_2336)) {
            return;
        }
        if (open) {
            SharedEnderChest.playEnderChestOpenSound(world, pos);
        } else {
            SharedEnderChest.playEnderChestCloseSound(world, pos);
        }
        world.method_8427(pos, class_2246.field_10443, 1, open ? 1 : 0);
    }

    private static File getFile(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("sharedenderchest.sav").toFile();
    }

    public void onServerStarted(MinecraftServer server) {
        File inventoryFile = SharedEnderChest.getFile(server);
        if (inventoryFile.exists()) {
            try (FileInputStream inventoryFileInputStream = new FileInputStream(inventoryFile);
                 DataInputStream inventoryFileDataInput = new DataInputStream(inventoryFileInputStream);){
                class_2487 nbt = class_2507.method_10629((InputStream)inventoryFileDataInput, (class_2505)class_2505.method_53898());
                class_2371 inventoryItemStacks = class_2371.method_10213((int)(ConfigManager.getConfig().sharedEnderChestRows * 9), (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)nbt, (class_2371)inventoryItemStacks, (class_7225.class_7874)server.method_30611());
                sharedInventory = new SharedInventory((class_2371<class_1799>)inventoryItemStacks);
            }
            catch (Exception e) {
                SurvivalFabric.LOGGER.error("Error while loading Shared Ender Chest: " + String.valueOf(e));
                sharedInventory = new SharedInventory(ConfigManager.getConfig().sharedEnderChestRows);
            }
        } else {
            sharedInventory = new SharedInventory(ConfigManager.getConfig().sharedEnderChestRows);
        }
    }

    public void onServerStopping(MinecraftServer server) {
        SharedEnderChest.saveInventory(server);
    }

    public void onEndTick(MinecraftServer server) {
        if (this.ticksUntilSave != -20L && --this.ticksUntilSave <= 0L) {
            SharedEnderChest.saveInventory(server);
            this.ticksUntilSave = 20L;
        }
    }

    public void onInitialize() {
        this.ticksUntilSave = 20L;
        UseBlockCallback listenerUseBlock = (player, world, hand, hitResult) -> {
            if (world.method_8320(hitResult.method_17777()).method_26204() instanceof class_2336 && !player.method_7325()) {
                if (!ConfigManager.getConfig().sharedEnderChestLimitedAccess) {
                    if (world.method_8608()) {
                        return class_1269.field_5812;
                    }
                    SharedEnderChest.openSharedEnderChest(player, world, hitResult.method_17777());
                    return class_1269.field_5812;
                }
                for (String name : ConfigManager.getConfig().sharedEnderChestNames) {
                    if (!name.toLowerCase().strip().equalsIgnoreCase(player.method_5820().toLowerCase())) continue;
                    if (world.method_8608()) {
                        return class_1269.field_5812;
                    }
                    SharedEnderChest.openSharedEnderChest(player, world, hitResult.method_17777());
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        };
        UseBlockCallback.EVENT.register((Object)listenerUseBlock);
        ServerLifecycleEvents.SERVER_STARTED.register((Object)this);
        ServerLifecycleEvents.SERVER_STOPPING.register((Object)this);
        ServerTickEvents.END_SERVER_TICK.register((Object)this);
    }
}

