/*
 * Decompiled with CFR 0.152.
 */
package wtf.hak.survivalfabric.mixin;

import java.util.Set;
import net.minecraft.class_1934;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wtf.hak.survivalfabric.commands.SpectatorCommand;
import wtf.hak.survivalfabric.config.ConfigManager;

@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Inject(method={"onPlayerConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V")})
    public void onPlayerConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        if (ConfigManager.getConfig().joinMessageEnabled && !player.method_5682().method_3724()) {
            class_5250 text = class_2561.method_43470((String)String.format(ConfigManager.getConfig().joinMessage, player.method_5477().getString()));
            player.method_7353((class_2561)text, false);
        }
    }

    @ModifyArg(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    private class_2561 onPlayerConnect(class_2561 text) {
        if (ConfigManager.getConfig().joinMessageEnabled) {
            String name = text.getString().split(" ")[0];
            return class_2561.method_43470((String)String.format(ConfigManager.getConfig().joinMessage, name));
        }
        return text;
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    public void onPlayerLeave(class_3222 player, CallbackInfo ci) {
        if (SpectatorCommand.spectating.containsKey(player)) {
            SpectatorCommand.LocationData loc = SpectatorCommand.spectating.remove(player);
            player.method_48105(loc.world, loc.x, loc.y, loc.z, Set.of(), loc.yaw, loc.pitch, false);
            player.method_7336(class_1934.field_9215);
        }
    }

    @Inject(method={"broadcast(Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBroadcast(class_7471 message, class_3222 sender, class_2556.class_7602 parameters, CallbackInfo ci) {
        if (sender != null) {
            String rawMessage = message.method_46291().getString().trim();
            boolean isCalcEnabled = ConfigManager.getConfig().chatCalcEnabled;
            boolean isMsgEnabled = ConfigManager.getConfig().chatMessageEnabled;
            String processedMessage = rawMessage;
            if (isCalcEnabled) {
                String expression = rawMessage.endsWith("=") ? rawMessage.substring(0, rawMessage.length() - 1).trim() : rawMessage;
                try {
                    String result = String.valueOf(this.evaluateExpression(expression));
                    StringBuilder sb = new StringBuilder(rawMessage).append("\u00a76");
                    if (rawMessage.contains(" ")) {
                        sb.append(" ");
                    }
                    if (!rawMessage.endsWith("=")) {
                        sb.append("=");
                    }
                    if (rawMessage.contains(" ")) {
                        sb.append(" ");
                    }
                    sb.append(result.endsWith(".0") ? result.substring(0, result.length() - 2) : result);
                    processedMessage = sb.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isMsgEnabled) {
                formatted = String.format(ConfigManager.getConfig().chatMessage, sender.method_5477().getString(), processedMessage);
                sender.method_5682().method_3760().method_43514((class_2561)class_2561.method_43470((String)formatted), false);
            } else if (isCalcEnabled) {
                formatted = "<" + sender.method_5477().getString() + "> " + processedMessage;
                sender.method_5682().method_3760().method_43514((class_2561)class_2561.method_43470((String)formatted), false);
            }
            ci.cancel();
        }
    }

    private double evaluateExpression(String expression) {
        return this.evaluate(expression.replaceAll("\\s", ""), new int[]{0});
    }

    private double evaluate(String expr, int[] index) {
        char op;
        double value = this.parseTerm(expr, index);
        while (index[0] < expr.length() && ((op = expr.charAt(index[0])) == '+' || op == '-')) {
            index[0] = index[0] + 1;
            double nextTerm = this.parseTerm(expr, index);
            value = op == '+' ? value + nextTerm : value - nextTerm;
        }
        return value;
    }

    private double parseTerm(String expr, int[] index) {
        char op;
        double value = this.parseFactor(expr, index);
        while (index[0] < expr.length() && ((op = expr.charAt(index[0])) == '*' || op == '/')) {
            index[0] = index[0] + 1;
            double nextFactor = this.parseFactor(expr, index);
            value = op == '*' ? value * nextFactor : value / nextFactor;
        }
        return value;
    }

    private double parseFactor(String expr, int[] index) {
        if (expr.charAt(index[0]) == '(') {
            index[0] = index[0] + 1;
            double value = this.evaluate(expr, index);
            index[0] = index[0] + 1;
            return value;
        }
        int start = index[0];
        while (index[0] < expr.length() && (Character.isDigit(expr.charAt(index[0])) || expr.charAt(index[0]) == '.')) {
            index[0] = index[0] + 1;
        }
        return Double.parseDouble(expr.substring(start, index[0]));
    }
}

