/*
 * Decompiled with CFR 0.152.
 */
package com.examplemod;

import com.examplemod.Config;
import com.examplemod.cas.IShieldData;
import com.examplemod.cas.ShieldCapability;
import com.examplemod.item.CosmolitArmorItem;
import com.examplemod.item.CustomSwordItem;
import com.examplemod.item.DiamondCrossbow;
import com.examplemod.item.GoldenCrossbow;
import com.examplemod.item.ModArmorMaterials;
import com.examplemod.item.NetheriteCrossbow;
import com.examplemod.network.Net;
import com.examplemod.util.ArmorUtil;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="moreweapon")
public class Swords {
    public static final String MODID = "moreweapon";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"moreweapon");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"moreweapon");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"moreweapon");
    public static final RegistryObject<Item> WOODEN_SWORD = ITEMS.register("wooden_sword", () -> new CustomSwordItem((Tier)Tiers.WOOD, 7.0, 0.8f, new Item.Properties().m_41503_(400)));
    public static final RegistryObject<Item> STONE_SWORD = ITEMS.register("stone_sword", () -> new CustomSwordItem((Tier)Tiers.STONE, 8.5, 0.7f, new Item.Properties().m_41503_(720)));
    public static final RegistryObject<Item> GOLDEN_SWORD = ITEMS.register("golden_sword", () -> new CustomSwordItem((Tier)Tiers.GOLD, 8.0, 0.4f, new Item.Properties().m_41503_(500)));
    public static final RegistryObject<Item> IRON_SWORD = ITEMS.register("iron_sword", () -> new CustomSwordItem((Tier)Tiers.IRON, 10.5, 0.6f, new Item.Properties().m_41503_(1200)));
    public static final RegistryObject<Item> DIAMOND_SWORD = ITEMS.register("diamond_sword", () -> new CustomSwordItem((Tier)Tiers.DIAMOND, 14.0, 0.6f, new Item.Properties().m_41503_(400)));
    public static final RegistryObject<Item> NETHERITE_SWORD = ITEMS.register("netherite_sword", () -> new CustomSwordItem((Tier)Tiers.NETHERITE, 15.0, 0.5f, new Item.Properties().m_41503_(3200)));
    public static final RegistryObject<Item> SMALL_WOODEN_SWORD = ITEMS.register("small_wooden_sword", () -> new CustomSwordItem((Tier)Tiers.WOOD, 2 - (int)Tiers.WOOD.m_6631_(), 2.2f, new Item.Properties().m_41503_(108)));
    public static final RegistryObject<Item> SMALL_STONE_SWORD = ITEMS.register("small_stone_sword", () -> new CustomSwordItem((Tier)Tiers.STONE, 4 - (int)Tiers.STONE.m_6631_(), 2.1f, new Item.Properties().m_41503_(178)));
    public static final RegistryObject<Item> SMALL_GOLDEN_SWORD = ITEMS.register("small_golden_sword", () -> new CustomSwordItem((Tier)Tiers.GOLD, 3.5, 1.7f, new Item.Properties().m_41503_(78)));
    public static final RegistryObject<Item> SMALL_IRON_SWORD = ITEMS.register("small_iron_sword", () -> new CustomSwordItem((Tier)Tiers.IRON, 6 - (int)Tiers.IRON.m_6631_(), 1.8f, new Item.Properties().m_41503_(1200)));
    public static final RegistryObject<Item> SMALL_DIAMOND_SWORD = ITEMS.register("small_diamond_sword", () -> new CustomSwordItem((Tier)Tiers.DIAMOND, 8 - (int)Tiers.DIAMOND.m_6631_(), 1.8f, new Item.Properties().m_41503_(672)));
    public static final RegistryObject<Item> SMALL_NETHERITE_SWORD = ITEMS.register("small_netherite_sword", () -> new CustomSwordItem((Tier)Tiers.NETHERITE, 6.0, 1.6f, new Item.Properties().m_41503_(1025)));
    public static final RegistryObject<Item> RAINBOW_STICK = ITEMS.register("rainbow_stick", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Block> COSMOLIT_ORE = BLOCKS.register("cosmolit_ore", () -> new Block(BlockBehaviour.Properties.m_284310_()));
    public static final RegistryObject<Item> COSMOLIT_ORE_ITEM = ITEMS.register("cosmolit_ore", () -> new BlockItem((Block)COSMOLIT_ORE.get(), new Item.Properties()));
    public static final RegistryObject<Item> SCALES = ITEMS.register("scales", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> GOLD_SCALED_HELMET = ITEMS.register("gold_scaled_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GOLD_SCALE, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> GOLD_SCALED_CHESTPLATE = ITEMS.register("gold_scaled_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GOLD_SCALE, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> GOLD_SCALED_LEGGINGS = ITEMS.register("gold_scaled_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GOLD_SCALE, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> GOLD_SCALED_BOOTS = ITEMS.register("gold_scaled_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GOLD_SCALE, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> IRON_SCALED_HELMET = ITEMS.register("iron_scaled_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.IRON_SCALE, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> IRON_SCALED_CHESTPLATE = ITEMS.register("iron_scaled_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.IRON_SCALE, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> IRON_SCALED_LEGGINGS = ITEMS.register("iron_scaled_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.IRON_SCALE, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> IRON_SCALED_BOOTS = ITEMS.register("iron_scaled_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.IRON_SCALE, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> DIAMOND_SCALED_HELMET = ITEMS.register("diamond_scaled_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.DIAMOND_SCALE, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> DIAMOND_SCALED_CHESTPLATE = ITEMS.register("diamond_scaled_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.DIAMOND_SCALE, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> DIAMOND_SCALED_LEGGINGS = ITEMS.register("diamond_scaled_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.DIAMOND_SCALE, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> DIAMOND_SCALED_BOOTS = ITEMS.register("diamond_scaled_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.DIAMOND_SCALE, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> NETHERITE_SCALED_HELMET = ITEMS.register("netherite_scaled_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.NETHERITE_SCALE, ArmorItem.Type.HELMET, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> NETHERITE_SCALED_CHESTPLATE = ITEMS.register("netherite_scaled_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.NETHERITE_SCALE, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> NETHERITE_SCALED_LEGGINGS = ITEMS.register("netherite_scaled_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.NETHERITE_SCALE, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> NETHERITE_SCALED_BOOTS = ITEMS.register("netherite_scaled_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.NETHERITE_SCALE, ArmorItem.Type.BOOTS, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> COSMOLIT_INGOT = ITEMS.register("cosmolit_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> COSMOLIT_HELMET = ITEMS.register("cosmolit_helmet", () -> new CosmolitArmorItem(ModArmorMaterials.COSMOLIT, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> COSMOLIT_CHESTPLATE = ITEMS.register("cosmolit_chestplate", () -> new CosmolitArmorItem(ModArmorMaterials.COSMOLIT, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> COSMOLIT_LEGGINGS = ITEMS.register("cosmolit_leggings", () -> new CosmolitArmorItem(ModArmorMaterials.COSMOLIT, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> COSMOLIT_BOOTS = ITEMS.register("cosmolit_boots", () -> new CosmolitArmorItem(ModArmorMaterials.COSMOLIT, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<CrossbowItem> BUFFED_CROSSBOW = ITEMS.register("buffed_crossbow", () -> new CrossbowItem(new Item.Properties().m_41487_(1).m_41503_(300)));
    public static final RegistryObject<CrossbowItem> IRON_CROSSBOW = ITEMS.register("iron_crossbow", () -> new CrossbowItem(new Item.Properties().m_41487_(1).m_41503_(400)));
    public static final RegistryObject<Item> GOLDEN_CROSSBOW = ITEMS.register("golden_crossbow", () -> new GoldenCrossbow(new Item.Properties().m_41487_(1).m_41503_(250)));
    public static final RegistryObject<Item> DIAMOND_CROSSBOW = ITEMS.register("diamond_crossbow", () -> new DiamondCrossbow(new Item.Properties().m_41487_(1).m_41503_(750)));
    public static final RegistryObject<Item> NETHERITE_CROSSBOW = ITEMS.register("netherite_crossbow", () -> new NetheriteCrossbow(new Item.Properties().m_41487_(1).m_41503_(1200).m_41486_()));
    public static final RegistryObject<Item> BIG_STICK = ITEMS.register("big_stick", () -> new Item(new Item.Properties()));
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("swords_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.swords_tab")).m_257737_(() -> ((Item)NETHERITE_SWORD.get()).m_7968_()).m_257501_((parameters, output) -> {
        for (RegistryObject item : ITEMS.getEntries()) {
            output.m_246326_((ItemLike)item.get());
        }
    }).m_257652_());

    public Swords(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        Net.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onRegisterCaps(RegisterCapabilitiesEvent e) {
        e.register(IShieldData.class);
    }

    @SubscribeEvent
    public void onAttachCaps(AttachCapabilitiesEvent<Entity> evt) {
        ShieldCapability.attachToPlayer(evt);
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone evt) {
        evt.getOriginal().getCapability(ShieldCapability.CAPABILITY).ifPresent(oldCap -> evt.getEntity().getCapability(ShieldCapability.CAPABILITY).ifPresent(newCap -> {
            newCap.loadNBT(oldCap.saveNBT());
            newCap.setDirty();
        }));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHurt(LivingHurtEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (!ArmorUtil.isFullCosmolitSet((Player)sp)) {
            return;
        }
        DamageSource src = evt.getSource();
        if (src.m_269533_(DamageTypeTags.f_268745_)) {
            return;
        }
        sp.getCapability(ShieldCapability.CAPABILITY).ifPresent(data -> {
            if (data.getActiveShields() <= 0) {
                return;
            }
            float newAmt = evt.getAmount() * 0.2f;
            if (newAmt < 0.0f) {
                newAmt = 0.0f;
            }
            data.consumeOneShield();
            evt.setAmount(newAmt);
            data.setDirty();
            Net.sync(sp, data);
            Net.syncToTracking(sp, data);
        });
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side != LogicalSide.SERVER || evt.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = evt.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        sp.getCapability(ShieldCapability.CAPABILITY).ifPresent(data -> {
            if (ArmorUtil.isFullCosmolitSet((Player)sp)) {
                int before = data.getActiveShields();
                data.tick(sp);
                if (data.isDirtyAndReset() || sp.f_19797_ % 40 == 0) {
                    Net.sync(sp, data);
                }
            } else if (sp.f_19797_ % 60 == 0 && data.isDirtyAndReset()) {
                Net.sync(sp, data);
            }
        });
    }

    @Mod.EventBusSubscriber(modid="moreweapon", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

