/*
 * Decompiled with CFR 0.152.
 */
package com.examplemod.cas;

import com.examplemod.cas.IShieldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;

public class ShieldData
implements IShieldData {
    public static final int MAX_SHIELDS = 4;
    public static final int TICKS_PER_SHIELD = 1200;
    private final List<Integer> cooldowns = new ArrayList<Integer>();
    private boolean dirty;

    @Override
    public int getMaxShields() {
        return 4;
    }

    @Override
    public int getActiveShields() {
        return Math.max(0, 4 - this.cooldowns.size());
    }

    @Override
    public float getNextRestoreProgress() {
        if (this.cooldowns.isEmpty()) {
            return 1.0f;
        }
        int t = this.cooldowns.get(0);
        return Mth.m_14036_((float)((float)t / 1200.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    public void consumeOneShield() {
        if (this.getActiveShields() <= 0) {
            return;
        }
        this.cooldowns.add(0, 0);
        this.dirty = true;
    }

    @Override
    public void tick(ServerPlayer player) {
        if (this.cooldowns.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.cooldowns.size(); ++i) {
            this.cooldowns.set(i, this.cooldowns.get(i) + 1);
        }
        int restored = 0;
        while (!this.cooldowns.isEmpty() && this.cooldowns.get(this.cooldowns.size() - 1) >= 1200) {
            this.cooldowns.remove(this.cooldowns.size() - 1);
            ++restored;
        }
        if (restored > 0) {
            this.dirty = true;
        }
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean d = this.dirty;
        this.dirty = false;
        return d;
    }

    @Override
    public CompoundTag saveNBT() {
        CompoundTag t = new CompoundTag();
        ListTag list = new ListTag();
        for (int v : this.cooldowns) {
            list.add((Object)IntTag.m_128679_((int)v));
        }
        t.m_128365_("cd", (Tag)list);
        return t;
    }

    @Override
    public void loadNBT(CompoundTag tag) {
        this.cooldowns.clear();
        if (tag.m_128425_("cd", 9)) {
            ListTag list = tag.m_128437_("cd", 3);
            for (Tag e : list) {
                this.cooldowns.add(((IntTag)e).m_7047_());
            }
        }
    }
}

