/*
 * Decompiled with CFR 0.152.
 */
package com.examplemod.item;

import com.examplemod.Swords;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ModArmorMaterials implements ArmorMaterial
{
    GOLD_SCALE("moreweapon:gold_scale", 12, ModArmorMaterials.defenseMap(4, 7, 5, 3), 25, SoundEvents.f_11676_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Swords.SCALES.get()}), 0.0f, 0.0f),
    IRON_SCALE("moreweapon:iron_scale", 15, ModArmorMaterials.defenseMap(4, 8, 7, 4), 9, SoundEvents.f_11677_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Swords.SCALES.get()}), 0.0f, 0.0f),
    DIAMOND_SCALE("moreweapon:diamond_scale", 33, ModArmorMaterials.defenseMap(5, 10, 8, 5), 10, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Swords.SCALES.get()}), 2.0f, 0.0f),
    NETHERITE_SCALE("moreweapon:netherite_scale", 37, ModArmorMaterials.defenseMap(5, 10, 8, 5), 15, SoundEvents.f_11679_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Swords.SCALES.get()}), 3.0f, 0.1f),
    COSMOLIT("moreweapon:cosmolit", 37, ModArmorMaterials.defenseMap(8, 20, 14, 7), 15, SoundEvents.f_11679_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Swords.SCALES.get()}), 3.0f, 0.1f);

    private static final Map<ArmorItem.Type, Integer> BASE_HEALTH;
    private final String name;
    private final int durabilityMultiplier;
    private final Map<ArmorItem.Type, Integer> defenseForType;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final LazyIngredient repairIngredient;
    private final float toughness;
    private final float knockbackResistance;

    private ModArmorMaterials(String name, int durabilityMultiplier, Map<ArmorItem.Type, Integer> defenseForType, int enchantmentValue, SoundEvent equipSound, LazyIngredient repairIngredient, float toughness, float knockbackResistance) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.defenseForType = defenseForType;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.repairIngredient = repairIngredient;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_HEALTH.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.defenseForType.getOrDefault(type, 0);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    private static Map<ArmorItem.Type, Integer> defenseMap(int helmet, int chest, int legs, int boots) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        map.put(ArmorItem.Type.HELMET, helmet);
        map.put(ArmorItem.Type.CHESTPLATE, chest);
        map.put(ArmorItem.Type.LEGGINGS, legs);
        map.put(ArmorItem.Type.BOOTS, boots);
        return map;
    }

    static {
        BASE_HEALTH = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        BASE_HEALTH.put(ArmorItem.Type.HELMET, 11);
        BASE_HEALTH.put(ArmorItem.Type.CHESTPLATE, 16);
        BASE_HEALTH.put(ArmorItem.Type.LEGGINGS, 15);
        BASE_HEALTH.put(ArmorItem.Type.BOOTS, 13);
    }

    @FunctionalInterface
    public static interface LazyIngredient {
        public Ingredient get();

        public static LazyIngredient of(Supplier<Ingredient> sup) {
            return sup::get;
        }
    }
}

