/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.CommonProxy;
import com.betterinvisibility.ConfigChangeHandler;
import com.betterinvisibility.InvisibleHandler;
import com.betterinvisibility.ModSoundEvents;
import com.betterinvisibility.OnPlayerAttack;
import com.betterinvisibility.PlayerTickHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="betterinvisibility", name="Better Invisibility", version="1.0.5", acceptedMinecraftVersions="[1.12,1.13)", guiFactory="com.betterinvisibility.GuiFactoryBetterInvisibility")
public class BetterInvisibility {
    public static final String modid = "betterinvisibility";
    public static final String name = "Better Invisibility";
    public static final String version = "1.0.5";
    public static final String acceptedversions = "[1.12,1.13)";
    public static Configuration config;
    @SidedProxy(clientSide="com.betterinvisibility.ClientProxy", serverSide="com.betterinvisibility.CommonProxy")
    public static CommonProxy proxy;
    public static boolean showArmorWeapons;
    public static boolean showParticles;
    public static boolean invisibleToMobs;
    public static int invisibilityRadius;
    public static int proximityDetectionDistance;
    public static boolean discoveryRemovesInvisibility;
    public static boolean attackRemovesInvisibility;
    public static boolean removeParticlesFromMobs;
    public static boolean blindWhenInvisible;
    public static boolean sneakWhenClose;
    public static boolean soundsOn;
    @Mod.Instance(value="betterinvisibility")
    public static BetterInvisibility instance;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        BetterInvisibility.syncConfig();
        FMLCommonHandler.instance().bus().register((Object)new ConfigChangeHandler());
        ModSoundEvents.registerSounds();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new InvisibleHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OnPlayerAttack());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
    }

    public static void syncConfig() {
        showArmorWeapons = config.get("Game Config", "Show Armor and Weapons When Invisible", false).getBoolean(false);
        showParticles = config.get("Game Config", "Show Invisibility Particle Effects on Player", false).getBoolean(false);
        invisibleToMobs = config.get("Game Config", "Player Hidden From Mobs When Invisible", true).getBoolean(true);
        invisibilityRadius = config.get("Game Config", "Invisibility Radius of Effect", 30).getInt(30);
        proximityDetectionDistance = config.get("Game Config", "Distance at Which Mobs Detect Nearby Player", 3).getInt(3);
        sneakWhenClose = config.get("Game Config", "Can Sneak by Mobs if Within Proximity Distance", true).getBoolean(true);
        discoveryRemovesInvisibility = config.get("Game Config", "Invisibility Removed if Discovered", true).getBoolean(true);
        attackRemovesInvisibility = config.get("Game Config", "Invisibility Removed if Player Attacks", true).getBoolean(true);
        removeParticlesFromMobs = config.get("Game Config", "Show Invisibility Particle Effects on Mobs", true).getBoolean(true);
        blindWhenInvisible = config.get("Game Config", "Add Blindness Effect When Invisible", false).getBoolean(false);
        soundsOn = config.get("Game Config", "Mod Sounds On", true).getBoolean(true);
        if (config.hasChanged()) {
            config.save();
            System.out.println("Better Invisibility configuration file updated. Please note, some updates may require restart.");
        }
    }
}

